/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import com.sonatype.insight.scan.file.nuget.model.NugetFactory;
import com.sonatype.insight.scan.file.nuget.model.Package;
import com.sonatype.insight.scan.file.nuget.model.Packages;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.thoughtworks.xstream.XStream;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.model.Component;

public class NugetPackagesConfigProcessor {
    private final Logger log = LoggerFactory.getLogger(NugetPackagesConfigProcessor.class);
    private final FileVisitor fileVisitor;

    public NugetPackagesConfigProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
    }

    public String process(TFile configFile) {
        this.log.debug("Processing packages.config file: {}", (Object)configFile.getAbsolutePath());
        List<String> fileContents = FileUtils.readLines(configFile);
        if (fileContents.isEmpty()) {
            return null;
        }
        XStream xStream = NugetFactory.newPackagesConfigInstance();
        Object unmarshalled = xStream.fromXML(String.join((CharSequence)"", fileContents));
        if (unmarshalled instanceof Packages) {
            Packages packages = (Packages)unmarshalled;
            ArrayList<Component> components = new ArrayList<Component>();
            if (packages.getPackages() != null) {
                for (Package pkg : packages.getPackages()) {
                    if (this.isValidPackage(pkg) && this.isNotSensitiveContent(pkg)) {
                        Component component = this.getComponent(pkg);
                        if (component == null) continue;
                        components.add(component);
                        continue;
                    }
                    this.log.debug("Excluding nuget dependency {}:{}", (Object)pkg.getId(), (Object)pkg.getVersion());
                }
            }
            try {
                return SbomUtils.createSbomXmlString(components);
            }
            catch (ParserConfigurationException | GeneratorException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean isNotSensitiveContent(Package pkg) {
        return this.fileVisitor.includeResourceName(pkg.getId());
    }

    private boolean isValidPackage(Package pkg) {
        return !this.isAnyBlank(pkg.getId(), pkg.getVersion());
    }

    private boolean isAnyBlank(String ... attributes) {
        for (String attribute : attributes) {
            if (null != attribute && !"".equals(attribute.trim())) continue;
            return true;
        }
        return false;
    }

    private Component getComponent(Package pkg) {
        Component component = SbomUtils.createLibraryComponent(pkg.getId(), pkg.getVersion());
        try {
            String purl = SbomUtils.createNugetPackageUrl(component.getName(), component.getVersion());
            component.setPurl(purl);
            return component;
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the file packages.config", (Throwable)e);
            return null;
        }
    }
}

