/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import com.sonatype.insight.scan.file.nuget.model.COMReference;
import com.sonatype.insight.scan.file.nuget.model.ItemGroup;
import com.sonatype.insight.scan.file.nuget.model.NugetFactory;
import com.sonatype.insight.scan.file.nuget.model.PackageReference;
import com.sonatype.insight.scan.file.nuget.model.Project;
import com.sonatype.insight.scan.file.nuget.model.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.thoughtworks.xstream.XStream;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.model.Component;

public class NugetCsProjFileProcessor {
    private final Logger log = LoggerFactory.getLogger(NugetCsProjFileProcessor.class);
    private final FileVisitor fileVisitor;

    public NugetCsProjFileProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
    }

    public String process(TFile csProjFile) {
        this.log.debug("Processing .csproj file: {}", (Object)csProjFile.getAbsolutePath());
        List<String> fileContents = FileUtils.readLines(csProjFile);
        if (fileContents.isEmpty()) {
            return null;
        }
        XStream xStream = NugetFactory.newCsProjInstance();
        try {
            Object unmarshalled = xStream.fromXML(String.join((CharSequence)"", fileContents));
            if (unmarshalled instanceof Project) {
                Project project = (Project)unmarshalled;
                ArrayList<Component> components = new ArrayList<Component>();
                List<ItemGroup> itemGroups = project.getItemGroups();
                if (itemGroups != null) {
                    for (ItemGroup itemGroup : itemGroups) {
                        this.processPackageReferences(components, itemGroup);
                        this.processReferences(components, itemGroup);
                        this.processComReferences(components, itemGroup);
                    }
                }
                try {
                    return SbomUtils.createSbomXmlString(components);
                }
                catch (ParserConfigurationException | GeneratorException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Skipping unsupported .csproj file {}", (Object)csProjFile.getAbsolutePath());
        }
        return null;
    }

    private void processReferences(List<Component> components, ItemGroup itemGroup) {
        List<Reference> references = itemGroup.getReferences();
        if (references != null) {
            for (Reference ref : references) {
                String name = ref.getName();
                String version = ref.getVersion();
                this.addComponentsIfValid(components, name, version, this.isValidReference(name, version));
            }
        }
    }

    private void processComReferences(List<Component> components, ItemGroup itemGroup) {
        List<COMReference> comReferences = itemGroup.getComReferences();
        if (comReferences != null) {
            for (COMReference ref : comReferences) {
                String include = ref.getInclude();
                String version = ref.getVersion();
                this.addComponentsIfValid(components, include, version, this.isValidReference(include, version));
            }
        }
    }

    private void processPackageReferences(List<Component> components, ItemGroup itemGroup) {
        List<PackageReference> packageReferences = itemGroup.getPackageReferences();
        if (packageReferences != null) {
            for (PackageReference ref : packageReferences) {
                String include = ref.getInclude();
                String version = ref.getVersion();
                this.addComponentsIfValid(components, include, version, this.isValidPackageReference(ref));
            }
        }
    }

    private void addComponentsIfValid(List<Component> components, String include, String version, Supplier<Boolean> checkValidReference) {
        if (checkValidReference.get().booleanValue() && this.isNotSensitiveContent(include)) {
            Component component = this.getComponent(include, version);
            if (component != null) {
                components.add(component);
            }
        } else {
            this.log.debug("Excluding nuget dependency {}:{}", (Object)include, (Object)version);
        }
    }

    private Supplier<Boolean> isValidReference(String name, String version) {
        return () -> StringUtils.isNoneBlank(name, version);
    }

    private Supplier<Boolean> isValidPackageReference(PackageReference packageReference) {
        return () -> {
            if (StringUtils.isAnyBlank(packageReference.getInclude(), packageReference.getVersion())) {
                return false;
            }
            if (this.isFloatingVersion(packageReference.getVersion())) {
                return false;
            }
            if ("none".equals(packageReference.getIncludeAssets()) || "all".equals(packageReference.getExcludeAssets())) {
                return false;
            }
            return true;
        };
    }

    private boolean isNotSensitiveContent(String componentName) {
        return this.fileVisitor.includeResourceName(componentName);
    }

    private boolean isFloatingVersion(String version) {
        return version.contains("*");
    }

    private Component getComponent(String name, String version) {
        Component component = SbomUtils.createLibraryComponent(name, version);
        try {
            String packageUrl = SbomUtils.createNugetPackageUrl(component.getName(), component.getVersion());
            component.setPurl(packageUrl);
            return component;
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the .csproj file", (Throwable)e);
            return null;
        }
    }
}

