/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.JavascriptPackageJsonProcessor;
import com.sonatype.insight.scan.file.JavascriptScannerResult;
import com.sonatype.insight.scan.file.ManifestProcessResult;
import com.sonatype.insight.scan.file.ModuleScanRequest;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import com.sonatype.insight.scan.model.ItemContentType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;

public class NpmPackageLockProcessor {
    private final FileVisitor fileVisitor;
    private final NpmManifestFileReader npmManifestFileReader;
    private final Logger log;
    private final NpmDependencies.NpmDependenciesCyloneDxBomSerializer serializer;

    public NpmPackageLockProcessor(FileVisitor fileVisitor, NpmManifestFileReader npmManifestFileReader) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
        this.npmManifestFileReader = npmManifestFileReader;
        this.serializer = new NpmDependencies.NpmDependenciesCyloneDxBomSerializer();
    }

    public ManifestProcessResult process(TFile file) {
        this.log.debug("Processing npm file: {}", (Object)file.getAbsolutePath());
        ManifestProcessResult result = new ManifestProcessResult();
        NpmDependencies npmDependencies = this.npmManifestFileReader.read(file);
        if (npmDependencies != null && npmDependencies.dependencies != null && !npmDependencies.dependencies.isEmpty()) {
            NpmDependencies.filterCylicDependencies(npmDependencies);
            this.filterSensitiveContent(npmDependencies.dependencies);
            result.content = this.serializer.serialize(npmDependencies);
            result.moduleScanRequest = this.deriveDependencyGraph(npmDependencies, file);
        }
        return result;
    }

    private ModuleScanRequest deriveDependencyGraph(NpmDependencies npmDependencies, TFile file) {
        ModuleScanRequest scanRequest = new ModuleScanRequest(this.fileVisitor.getScanSession());
        scanRequest.setBasedir(file.getParentFile());
        JavascriptScannerResult packageJsonContents = new JavascriptPackageJsonProcessor().readPackageJsonGivenSibling(file);
        Map<String, String> directDependencies = NpmManifestFileReader.getDirectDependencies(packageJsonContents);
        if (StringUtils.isAnyBlank(npmDependencies.name, npmDependencies.version) || directDependencies.isEmpty()) {
            return null;
        }
        String purl = this.getPurl(npmDependencies.name, npmDependencies.version);
        scanRequest.setModule(purl, ItemContentType.NPM_FILE.format, file);
        this.addDependencies(scanRequest, directDependencies, npmDependencies);
        return scanRequest;
    }

    private void addDependencies(ModuleScanRequest request, Map<String, String> directDependencies, NpmDependencies npmDependencies) {
        Set directs = npmDependencies.dependencies.stream().filter(npmDependency -> directDependencies.entrySet().stream().anyMatch(directDependencyName -> NpmManifestFileReader.npmDependencyMatchesDirectDependency(npmDependency, directDependencyName))).collect(Collectors.toSet());
        NpmDependency root = new NpmDependency(npmDependencies.name, npmDependencies.version);
        root.dependencies.addAll(npmDependencies.dependencies);
        for (NpmDependency dependency : directs) {
            String id = this.getPurl(dependency.packageId, dependency.version);
            if (id == null) continue;
            ArrayList<NpmDependency> dependencyChain = new ArrayList<NpmDependency>();
            dependencyChain.add(root);
            dependencyChain.add(dependency);
            List<String> childIds = this.addChildDependencies(request, dependencyChain);
            request.addDependency(id, true, childIds);
        }
    }

    private List<String> addChildDependencies(ModuleScanRequest request, List<NpmDependency> dependencyChain) {
        NpmDependency dependency = dependencyChain.get(dependencyChain.size() - 1);
        ArrayList<String> childIds = new ArrayList<String>();
        if (!dependency.requires.isEmpty()) {
            for (Map.Entry<String, String> dep : dependency.requires.entrySet()) {
                NpmDependency transitive = this.getTransitiveDependency(dependencyChain, new NpmDependency(dep.getKey(), dep.getValue()));
                if (transitive == null) continue;
                if (this.containsDependency(dependencyChain, transitive)) {
                    transitive = this.copyWithoutChildren(transitive);
                }
                ArrayList<NpmDependency> childDependencyChain = new ArrayList<NpmDependency>(dependencyChain);
                childDependencyChain.add(transitive);
                this.addChildDependencyToModuleScanRequest(request, childDependencyChain, childIds, transitive);
            }
        } else {
            dependency.dependencies.forEach(d -> {
                NpmDependency transitive = d;
                if (this.containsDependency(dependencyChain, (NpmDependency)d)) {
                    transitive = this.copyWithoutChildren(transitive);
                }
                ArrayList<NpmDependency> childDependencyChain = new ArrayList<NpmDependency>(dependencyChain);
                childDependencyChain.add(transitive);
                this.addChildDependencyToModuleScanRequest(request, childDependencyChain, childIds, transitive);
            });
        }
        return childIds;
    }

    private boolean containsDependency(List<NpmDependency> dependencies, NpmDependency dependency) {
        return dependencies.stream().anyMatch(n -> n.packageId.equals(dependency.packageId) && n.version.equals(dependency.version));
    }

    private NpmDependency copyWithoutChildren(NpmDependency npmDependency) {
        NpmDependency copy = new NpmDependency(npmDependency.packageId, npmDependency.version);
        copy.specifiers.addAll(npmDependency.specifiers);
        return copy;
    }

    private void addChildDependencyToModuleScanRequest(ModuleScanRequest request, List<NpmDependency> dependencyChain, List<String> siblingIds, NpmDependency dependency) {
        String id = this.getPurl(dependency.packageId, dependency.version);
        if (id != null) {
            siblingIds.add(id);
            List<String> childIds = this.addChildDependencies(request, dependencyChain);
            request.addDependency(id, false, childIds);
        }
    }

    private NpmDependency getTransitiveDependency(List<NpmDependency> dependencyChain, NpmDependency requiredDep) {
        NpmDependency dependency = null;
        for (int i = dependencyChain.size() - 1; i >= 0 && (dependency = (NpmDependency)dependencyChain.get((int)i).dependencies.stream().filter(d -> NpmManifestFileReader.matchesDependency(d, requiredDep)).findFirst().orElse(null)) == null; --i) {
        }
        return dependency;
    }

    private String getPurl(String packageId, String version) {
        try {
            return PackageURLBuilder.aPackageURL().withType(ItemContentType.NPM_FILE.format).withName(packageId).withVersion(version).build().canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the npm file", (Throwable)e);
            return null;
        }
    }

    private void filterSensitiveContent(Set<NpmDependency> npmDependencies) {
        Iterator<NpmDependency> iterator = npmDependencies.iterator();
        while (iterator.hasNext()) {
            NpmDependency npmDependency = iterator.next();
            if (!this.fileVisitor.includeResourceName(npmDependency.packageId)) {
                this.log.debug("Not including npm dependency '{}'", (Object)npmDependency.packageId);
                iterator.remove();
                continue;
            }
            if (npmDependency.dependencies.isEmpty()) continue;
            this.filterSensitiveContent(npmDependency.dependencies);
        }
    }
}

