/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.JavascriptPackageJsonProcessor;
import com.sonatype.insight.scan.file.JavascriptScannerResult;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.google.gson.JsonParser;
import zz.com.vdurmont.semver4j.Requirement;
import zz.com.vdurmont.semver4j.Semver;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.io.IOUtils;
import zz.org.apache.commons.lang3.StringUtils;

interface NpmManifestFileReader {
    public static final Logger log = LoggerFactory.getLogger(NpmManifestFileReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String readContent(TFile file) {
        try (TFileInputStream inputStream = new TFileInputStream(file);){
            String string = IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public NpmDependencies read(TFile file) {
        String content = this.readContent(file);
        if (StringUtils.isBlank(content)) {
            return null;
        }
        NpmDependencies npmDependencies = new NpmDependencies.NpmDependenciesDeserializer().deserialize(JsonParser.parseString(content));
        if (npmDependencies.lockfileVersion != null && npmDependencies.lockfileVersion != 1) {
            NpmDependencies filteredNpmDependencies = this.createNpmDependenciesFilteredByPackageJson(file, npmDependencies.dependencies);
            if (filteredNpmDependencies.name == null) {
                filteredNpmDependencies.name = npmDependencies.name;
            }
            if (filteredNpmDependencies.version == null) {
                filteredNpmDependencies.version = npmDependencies.version;
            }
            npmDependencies = filteredNpmDependencies;
        }
        return npmDependencies;
    }

    default public NpmDependencies createNpmDependenciesFilteredByPackageJson(TFile file, Set<NpmDependency> dependencies) {
        NpmDependencies npmDependencies = new NpmDependencies();
        npmDependencies.dependencies = new LinkedHashSet<NpmDependency>(dependencies);
        JavascriptScannerResult packageJson = new JavascriptPackageJsonProcessor().readPackageJsonGivenSibling(file);
        if (packageJson != null) {
            Map<String, String> directDependencies;
            if (packageJson.getName() != null && packageJson.getVersion() != null) {
                npmDependencies.name = packageJson.getName().toString();
                npmDependencies.version = packageJson.getVersion().toString();
            }
            if (!(directDependencies = NpmManifestFileReader.getDirectDependencies(packageJson)).isEmpty()) {
                npmDependencies.dependencies.removeIf(npmDependency -> directDependencies.entrySet().stream().noneMatch(directDependency -> NpmManifestFileReader.npmDependencyMatchesDirectDependency(npmDependency, directDependency)));
            }
        }
        return npmDependencies;
    }

    public static Map<String, String> getDirectDependencies(JavascriptScannerResult packageJson) {
        if (packageJson == null || packageJson.getDependencies() == null || !(packageJson.getDependencies() instanceof Map)) {
            return Collections.emptyMap();
        }
        return (Map)packageJson.getDependencies();
    }

    public static boolean npmDependencyMatchesDirectDependency(NpmDependency npmDependency, Map.Entry<String, String> directDependency) {
        if (npmDependency.specifiers.isEmpty()) {
            return NpmManifestFileReader.matchesDependency(npmDependency, new NpmDependency(directDependency.getKey(), directDependency.getValue()));
        }
        return npmDependency.packageId.equals(directDependency.getKey()) && npmDependency.specifiers.contains(directDependency.getValue());
    }

    public static boolean matchesDependency(NpmDependency dependency, NpmDependency requiredDep) {
        if (StringUtils.isAnyBlank(dependency.packageId, dependency.version, requiredDep.packageId, requiredDep.version)) {
            return false;
        }
        if (!dependency.packageId.equals(requiredDep.packageId)) {
            return false;
        }
        Semver semNPM = null;
        Requirement requirement = null;
        try {
            semNPM = new Semver(dependency.version, Semver.SemverType.NPM);
            requirement = Requirement.buildNPM(requiredDep.version);
        }
        catch (Exception e) {
            if (semNPM == null) {
                log.debug("Unable to create semantic version for {}:{}", new Object[]{dependency.packageId, dependency.version, e});
            }
            log.debug("Unable to create semantic version requirement {} for {}:{}", new Object[]{requiredDep.version, dependency.packageId, dependency.version, e});
        }
        if (semNPM != null && requirement != null) {
            try {
                return semNPM.satisfies(requirement);
            }
            catch (Exception e) {
                log.debug("Unable to check semantic version requirement {} for {}:{}", new Object[]{requiredDep.version, dependency.packageId, dependency.version, e});
            }
        }
        return dependency.version.equals(requiredDep.version);
    }

    public static String removeQuotes(String input) {
        return input.replaceAll("['\"]", "");
    }
}

