/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.SbomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.lang3.ObjectUtils;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.apache.maven.model.Dependency;
import zz.org.apache.maven.model.Model;
import zz.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import zz.org.cyclonedx.model.Component;

public class MavenPomProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;
    private static final List<String> UNSUPPORTED_SCOPES = Arrays.asList("test", "provided");

    public MavenPomProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing pom.xml file: {}", (Object)file.getAbsolutePath());
        try (TFileInputStream inputStream = new TFileInputStream(file);){
            Model model = new MavenXpp3Reader().read(inputStream);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>(model.getDependencies());
            if (model.getDependencyManagement() != null) {
                dependencies.addAll(model.getDependencyManagement().getDependencies());
            }
            if (!dependencies.isEmpty()) {
                LinkedHashSet<Component> components = new LinkedHashSet<Component>();
                Object object = dependencies.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = SbomUtils.createSbomXmlString(new ArrayList<Component>(components));
                        return object;
                    }
                    Dependency dependency = (Dependency)object.next();
                    if (!this.isNotSensitiveContent(dependency) || UNSUPPORTED_SCOPES.contains(dependency.getScope()) || !this.isValidDependency(dependency)) continue;
                    this.resolveDependency(dependency, model.getProperties(), components);
                }
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isValidDependency(Dependency dep) {
        return this.isNotBlank(dep.getArtifactId()) && this.isNotBlank(dep.getGroupId()) && this.isNotBlank(dep.getVersion()) && this.isNotRange(dep.getVersion());
    }

    private boolean isNotRange(String version) {
        return !StringUtils.containsAny((CharSequence)version, (CharSequence)"[]()");
    }

    private void resolveDependency(Dependency dependency, Properties properties, Set<Component> components) {
        String artifactId = this.resolvePropertyValue(dependency.getArtifactId(), properties);
        String groupId = this.resolvePropertyValue(dependency.getGroupId(), properties);
        String version = this.resolvePropertyValue(dependency.getVersion(), properties);
        String extension = this.resolvePropertyValue(dependency.getType(), properties);
        if (ObjectUtils.allNotNull(artifactId, groupId, version, extension)) {
            Component component = SbomUtils.createLibraryComponent(artifactId, version);
            component.setGroup(groupId);
            component.setScope(Component.Scope.REQUIRED);
            if (dependency.getClassifier() != null) {
                String classifier = this.resolvePropertyValue(dependency.getClassifier(), properties);
                if (this.isNotBlank(classifier)) {
                    this.addComponent(artifactId, groupId, version, extension, classifier, component, components);
                }
            } else {
                this.addComponent(artifactId, groupId, version, extension, null, component, components);
            }
        }
    }

    private String resolvePropertyValue(String value, Properties properties) {
        if (value != null && value.startsWith("$")) {
            String property = value.replaceAll("[${}]", "");
            return properties.getProperty(property);
        }
        return value;
    }

    private boolean isNotSensitiveContent(Dependency dependency) {
        return this.fileVisitor.includeResourceName(dependency.getGroupId()) && this.fileVisitor.includeResourceName(dependency.getArtifactId());
    }

    private boolean isNotBlank(String value) {
        return value != null && !value.isEmpty();
    }

    private void addComponent(String artifactId, String groupId, String version, String extension, String classifier, Component component, Set<Component> components) {
        try {
            component.setPurl(SbomUtils.createMavenPackageUrl(artifactId, groupId, version, extension, classifier));
            components.add(component);
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Invalid coordinates found in the pom file", (Throwable)e);
        }
    }
}

