/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.file.AlpineProcessor;
import com.sonatype.insight.scan.file.BowerProcessor;
import com.sonatype.insight.scan.file.CargoProcessor;
import com.sonatype.insight.scan.file.ClairScannerResultProcessor;
import com.sonatype.insight.scan.file.CocoaPodsProcessor;
import com.sonatype.insight.scan.file.ConanFileProcessor;
import com.sonatype.insight.scan.file.ConanFilePyReader;
import com.sonatype.insight.scan.file.ConanFileTxtReader;
import com.sonatype.insight.scan.file.CondaProcessor;
import com.sonatype.insight.scan.file.Config;
import com.sonatype.insight.scan.file.CranPackageProcessor;
import com.sonatype.insight.scan.file.DebianProcessor;
import com.sonatype.insight.scan.file.DrupalProcessor;
import com.sonatype.insight.scan.file.FileScanner;
import com.sonatype.insight.scan.file.FileScannerResultProcessor;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.GoLockFileReader;
import com.sonatype.insight.scan.file.GoModuleFileReader;
import com.sonatype.insight.scan.file.GoModuleProcessor;
import com.sonatype.insight.scan.file.GradleBuildProcessor;
import com.sonatype.insight.scan.file.JavascriptPackageJsonProcessor;
import com.sonatype.insight.scan.file.ManifestProcessResult;
import com.sonatype.insight.scan.file.MavenPomProcessor;
import com.sonatype.insight.scan.file.ModuleScanRequest;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.file.NpmPackageLockProcessor;
import com.sonatype.insight.scan.file.NugetCsProjFileProcessor;
import com.sonatype.insight.scan.file.NugetPackagesConfigProcessor;
import com.sonatype.insight.scan.file.PhpComposerProcessor;
import com.sonatype.insight.scan.file.PnpmLockFileReader;
import com.sonatype.insight.scan.file.PoetryLockProcessor;
import com.sonatype.insight.scan.file.PythonRequirementsProcessor;
import com.sonatype.insight.scan.file.RubyGemsProcessor;
import com.sonatype.insight.scan.file.SwiftPackageResolvedProcessor;
import com.sonatype.insight.scan.file.YarnReaderFactory;
import com.sonatype.insight.scan.file.YumPackageProcessor;
import com.sonatype.insight.scan.hash.Digester;
import com.sonatype.insight.scan.model.ItemContentType;
import com.sonatype.insight.scan.model.ScanItem;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.codec.digest.DigestUtils;
import zz.org.apache.commons.lang3.tuple.Pair;

public class ManifestContentProcessor {
    private static final String NODE_MODULES_FILENAME = "node_modules";
    public static final String IAC_PATH_PREFIX = "iac:";
    private final Logger log;
    private final Config config;
    public final Anonymizer anonymizer;
    public final Digester digester;

    public ManifestContentProcessor(Config config, Anonymizer anonymizer, Digester digester, Logger log) {
        this.config = config;
        this.anonymizer = anonymizer;
        this.digester = digester;
        this.log = log;
    }

    protected void setScanItemContent(ScanItem item, TFile file, FileVisitor fileVisitor) {
        SupportedManifest supportedManifest = SupportedManifest.fromFilename(file.getName());
        if (null == supportedManifest) {
            Set<String> licensedFeatures;
            String content;
            if (this.isSbomFile(file)) {
                content = new FileScannerResultProcessor(fileVisitor.log).process(file);
                this.setItemContent(item, content, ItemContentType.SBOM);
                fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
            } else if (this.isTerraformPlanFile(file) && !this.isIacFile(file)) {
                licensedFeatures = fileVisitor.getScanSession().getLicensedFeatures();
                if (licensedFeatures != null && licensedFeatures.contains("infrastructure-as-code-pack")) {
                    String content2 = new FileScannerResultProcessor(fileVisitor.log).process(file);
                    this.setItemContent(item, content2, ItemContentType.TERRAFORM_PLAN_JSON);
                    item.setSha1(DigestUtils.sha1Hex(content2));
                    fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
                }
            } else if (this.isNeuVectorContainerFile(file)) {
                this.log.debug("Container file {} is being processed.", (Object)file.getPath());
                content = fileVisitor.processContainerFile(file);
                if (content != null) {
                    this.log.debug("Content received for processed container file: {}.", (Object)file.getPath());
                    this.setItemContent(item, content, ItemContentType.CONTAINER_URI);
                    String sha1 = DigestUtils.sha1Hex(content);
                    item.setSha1(sha1);
                    fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
                } else {
                    this.log.debug("Container file processing returned no content.");
                }
            } else if (this.isIacFile(file)) {
                try {
                    licensedFeatures = fileVisitor.getScanSession().getLicensedFeatures();
                    if (licensedFeatures != null && licensedFeatures.contains("infrastructure-as-code-pack")) {
                        List iacFiles = Files.walk(Paths.get(this.getIacFileFromPath(file).getPath(), new String[0]), new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).filter(path -> !path.toFile().isHidden()).map(path -> new TFile(path.toFile())).collect(Collectors.toList());
                        for (TFile iacFile : iacFiles) {
                            String content3 = new FileScannerResultProcessor(fileVisitor.log).process(iacFile);
                            fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
                            ScanItem scanItem = new ScanItem();
                            scanItem.setPath(iacFile.getPath().replace('\\', '/'));
                            this.setItemContent(scanItem, content3, ItemContentType.IAC_FILE);
                            scanItem.setSha1(DigestUtils.sha1Hex(content3));
                            fileVisitor.addScanItem(scanItem);
                            fileVisitor.getStats().files.incrementAndGet();
                        }
                    }
                }
                catch (IOException e) {
                    this.log.warn("Could not process iac file: {}. {}", (Object)file.getPath(), (Object)e.getMessage());
                    fileVisitor.getStats().errorCount.incrementAndGet();
                }
            }
            if (this.isCsProjFile(file)) {
                content = new NugetCsProjFileProcessor(fileVisitor).process(file);
                this.setItemContent(item, content, ItemContentType.NUGET_CSPROJ_FILE);
            }
            return;
        }
        String content = "";
        ItemContentType itemContentType = supportedManifest.itemContentType;
        ModuleScanRequest moduleScanRequest = null;
        switch (supportedManifest) {
            case ALPINE_MANIFEST: {
                content = new AlpineProcessor(fileVisitor).process(file);
                break;
            }
            case BOM_XML_MANIFEST: {
                content = new FileScannerResultProcessor(fileVisitor.log).process(file);
                fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
                break;
            }
            case BOWER_MANIFEST: {
                if (!this.config.bowerScanningEnabled) break;
                content = new BowerProcessor(fileVisitor).process(file);
                break;
            }
            case CARGO_MANIFEST: {
                content = new CargoProcessor(fileVisitor).process(file);
                break;
            }
            case CLAIRE_SCANNER_OUTPUT_MANIFEST: {
                content = new ClairScannerResultProcessor(fileVisitor).process(file);
                fileVisitor.getScanSession().getScan().setHasThirdPartyScanContent(true);
                break;
            }
            case COCOA_PODS_MANIFEST: {
                content = new CocoaPodsProcessor(fileVisitor).process(file);
                break;
            }
            case CONAN_FILE_TXT_MANIFEST: 
            case CONAN_INFO_TXT_MANIFEST: {
                content = new ConanFileProcessor(fileVisitor, new ConanFileTxtReader()).process(file);
                break;
            }
            case CONAN_PY_MANIFEST: {
                content = new ConanFileProcessor(fileVisitor, new ConanFilePyReader()).process(file);
                break;
            }
            case CONDA_MANIFEST: {
                Pair<Boolean, String> condaResult = new CondaProcessor(fileVisitor).process(file);
                itemContentType = condaResult.getLeft() != false ? ItemContentType.SBOM : SupportedManifest.CONDA_MANIFEST.itemContentType;
                content = condaResult.getRight();
                break;
            }
            case CRAN_PACKAGES_MANIFEST: {
                content = new CranPackageProcessor(fileVisitor).process(file);
                break;
            }
            case DEBIAN_MANIFEST: {
                content = new DebianProcessor(fileVisitor).process(file);
                break;
            }
            case DRUPAL_MANIFEST: {
                content = new DrupalProcessor(fileVisitor).process(file);
                break;
            }
            case GO_LIST_MANIFEST: 
            case GO_MODULE_MANIFEST: {
                content = new GoModuleProcessor(fileVisitor, new GoModuleFileReader()).process(file);
                break;
            }
            case GO_LOCK_MANIFEST: {
                content = new GoModuleProcessor(fileVisitor, new GoLockFileReader()).process(file);
                break;
            }
            case JAVASCRIPT_PACKAGE_JSON_MANIFEST: {
                content = new JavascriptPackageJsonProcessor().process(file);
                break;
            }
            case NPM_PACKAGE_LOCK_MANIFEST: 
            case NPM_SHRINKWRAP_MANIFEST: {
                if (!this.notADuplicateManifest(file) || !this.notInNodeModulesDir(file)) break;
                ManifestProcessResult manifestResult = new NpmPackageLockProcessor(fileVisitor, new NpmManifestFileReader(){}).process(file);
                content = manifestResult.content;
                moduleScanRequest = manifestResult.moduleScanRequest;
                break;
            }
            case PHP_COMPOSER_MANIFEST: {
                content = new PhpComposerProcessor(fileVisitor).process(file);
                break;
            }
            case PNPM_LOCK_MANIFEST: {
                if (!this.notInNodeModulesDir(file)) break;
                ManifestProcessResult manifestResult = new NpmPackageLockProcessor(fileVisitor, new PnpmLockFileReader()).process(file);
                content = manifestResult.content;
                moduleScanRequest = manifestResult.moduleScanRequest;
                break;
            }
            case MAVEN_POM_MANIFEST: {
                content = new MavenPomProcessor(fileVisitor).process(file);
                break;
            }
            case GRADLE_BUILD_MANIFEST: {
                content = new GradleBuildProcessor(fileVisitor).process(file);
                break;
            }
            case PYTHON_REQUIREMENTS_MANIFEST: {
                content = new PythonRequirementsProcessor(fileVisitor).process(file);
                break;
            }
            case RUBY_GEMS_MANIFEST: {
                content = new RubyGemsProcessor(fileVisitor).process(file);
                break;
            }
            case YARN_LOCK_MANIFEST: {
                if (!this.notInNodeModulesDir(file)) break;
                ManifestProcessResult manifestResult = new NpmPackageLockProcessor(fileVisitor, YarnReaderFactory.getInstance(file)).process(file);
                content = manifestResult.content;
                moduleScanRequest = manifestResult.moduleScanRequest;
                break;
            }
            case YUM_PACKAGES_MANIFEST: {
                content = new YumPackageProcessor(fileVisitor).process(file);
                break;
            }
            case NUGET_PACKAGES_CONFIG_MANIFEST: {
                content = new NugetPackagesConfigProcessor(fileVisitor).process(file);
                break;
            }
            case SWIFT_PACKAGE_MANIFEST: {
                content = new SwiftPackageResolvedProcessor(fileVisitor).process(file);
                break;
            }
            case POETRY_LOCK_MANIFEST: {
                content = new PoetryLockProcessor(fileVisitor).process(file);
                break;
            }
        }
        this.setItemContent(item, content, itemContentType);
        this.scanModules(moduleScanRequest);
    }

    private boolean notInNodeModulesDir(TFile file) {
        while (file != null) {
            if (NODE_MODULES_FILENAME.equals(file.getName())) {
                return false;
            }
            file = file.getParentFile();
        }
        return true;
    }

    private boolean notADuplicateManifest(TFile file) {
        return !SupportedManifest.NPM_PACKAGE_LOCK_MANIFEST.filename.equals(file.getName()) || Files.notExists(Paths.get(file.getParent(), SupportedManifest.NPM_SHRINKWRAP_MANIFEST.filename), new LinkOption[0]);
    }

    private void scanModules(ModuleScanRequest moduleScanRequest) {
        if (moduleScanRequest != null) {
            FileScanner fileScanner = new FileScanner(this.digester, this.anonymizer);
            fileScanner.scan(moduleScanRequest);
        }
    }

    private void setItemContent(ScanItem item, String content, ItemContentType itemContentType) {
        if (content != null && !content.trim().isEmpty()) {
            item.setContentType(itemContentType);
            item.setContent(content);
        }
    }

    private boolean isCsProjFile(TFile file) {
        return file.getName().endsWith(".csproj");
    }

    private boolean isSbomFile(TFile file) {
        return file.getName().matches("(^[a-zA-Z0-9][a-zA-Z0-9_.-]*-(?i)bom.xml(?i)$)|(^(?i)bom.xml(?i)$)");
    }

    private boolean isTerraformPlanFile(TFile file) {
        return file.getName().endsWith(".tfplan");
    }

    private boolean isNeuVectorContainerFile(TFile file) {
        return file.getPath().startsWith("container:");
    }

    private boolean isIacFile(TFile file) {
        return file.getPath().startsWith(IAC_PATH_PREFIX);
    }

    private TFile getIacFileFromPath(TFile file) {
        return new TFile(file.getPath().substring(IAC_PATH_PREFIX.length()));
    }

    public static enum SupportedManifest {
        ALPINE_MANIFEST("alpine.txt", ItemContentType.ALPINE_FILE),
        BOM_XML_MANIFEST("bom.xml", ItemContentType.SBOM),
        BOWER_MANIFEST("bower.json", ItemContentType.BOWER_FILE),
        CARGO_MANIFEST("Cargo.lock", ItemContentType.CARGO),
        CLAIRE_SCANNER_OUTPUT_MANIFEST("clair-scanner-output.json", ItemContentType.CLAIR_SCANNER),
        COCOA_PODS_MANIFEST("Podfile.lock", ItemContentType.COCOA_PODS),
        CONAN_FILE_TXT_MANIFEST("conanfile.txt", ItemContentType.CONAN_FILE),
        CONAN_INFO_TXT_MANIFEST("conaninfo.txt", ItemContentType.CONAN_FILE),
        CONAN_PY_MANIFEST("conanfile.py", ItemContentType.CONAN_FILE),
        CONDA_MANIFEST("conda.txt", ItemContentType.CONDA_FILE),
        CRAN_PACKAGES_MANIFEST("cran-installed.packages", ItemContentType.CRAN_PACKAGES_FILE),
        DEBIAN_MANIFEST("debian-packages.txt", ItemContentType.DEBIAN_FILE),
        DRUPAL_MANIFEST("drupal-components.csv", ItemContentType.DRUPAL_FILE),
        GO_LIST_MANIFEST("go.list", ItemContentType.GO_MODULE),
        GO_LOCK_MANIFEST("Gopkg.lock", ItemContentType.GO_MODULE),
        GO_MODULE_MANIFEST("go.sum", ItemContentType.GO_MODULE),
        JAVASCRIPT_PACKAGE_JSON_MANIFEST("package.json", ItemContentType.JAVASCRIPT_PACKAGE_JSON),
        NPM_PACKAGE_LOCK_MANIFEST("package-lock.json", ItemContentType.NPM_FILE_SBOM),
        NPM_SHRINKWRAP_MANIFEST("npm-shrinkwrap.json", ItemContentType.NPM_FILE_SBOM),
        MAVEN_POM_MANIFEST("pom.xml", ItemContentType.MAVEN_POM_FILE),
        GRADLE_BUILD_MANIFEST("build.gradle", ItemContentType.GRADLE_BUILD_FILE),
        PHP_COMPOSER_MANIFEST("composer.lock", ItemContentType.PHP_COMPOSER),
        PNPM_LOCK_MANIFEST("pnpm-lock.yaml", ItemContentType.NPM_FILE_SBOM),
        PYTHON_REQUIREMENTS_MANIFEST("requirements.txt", ItemContentType.PYTHON_REQUIREMENTS),
        POETRY_LOCK_MANIFEST("poetry.lock", ItemContentType.POETRY_LOCK),
        RUBY_GEMS_MANIFEST("Gemfile.lock", ItemContentType.RUBY_GEMS),
        YARN_LOCK_MANIFEST("yarn.lock", ItemContentType.NPM_FILE_SBOM),
        NUGET_PACKAGES_CONFIG_MANIFEST("packages.config", ItemContentType.NUGET_PACKAGES_CONFIG_FILE),
        YUM_PACKAGES_MANIFEST("yum-packages.txt", ItemContentType.YUM_PACKAGE_FILE),
        SWIFT_PACKAGE_MANIFEST("Package.resolved", ItemContentType.SWIFT_PACKAGE_FILE);

        private static final Map<String, SupportedManifest> FILENAME_MAP;
        private static List<String> filenameList;
        private final String filename;
        private final ItemContentType itemContentType;

        private SupportedManifest(String filename, ItemContentType itemContentType) {
            this.filename = filename;
            this.itemContentType = itemContentType;
        }

        public static SupportedManifest fromFilename(String filename) {
            return FILENAME_MAP.get(filename);
        }

        public static List<String> getListing() {
            return filenameList;
        }

        static {
            FILENAME_MAP = new HashMap<String, SupportedManifest>();
            ArrayList<String> tempFilenameList = new ArrayList<String>();
            for (SupportedManifest e : SupportedManifest.values()) {
                FILENAME_MAP.put(e.filename, e);
                tempFilenameList.add(e.filename);
            }
            filenameList = Collections.unmodifiableList(tempFilenameList);
        }
    }
}

