/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.JavascriptScannerResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.google.gson.Gson;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;

public class JavascriptPackageJsonProcessor {
    private final Logger log = LoggerFactory.getLogger(JavascriptPackageJsonProcessor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile packageJsonFile) {
        this.log.debug("Processing package.json file: {}", (Object)packageJsonFile.getAbsolutePath());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(packageJsonFile), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String string = gson.toJson(gson.fromJson((Reader)reader, JavascriptScannerResult.class));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JavascriptScannerResult readPackageJsonGivenSibling(TFile siblingFile) {
        TFile parentFile = siblingFile.getParentFile();
        if (parentFile == null) {
            return null;
        }
        TFile packageJsonFile = new TFile(parentFile.getPath() + "/package.json");
        if (!packageJsonFile.isFile()) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(packageJsonFile), StandardCharsets.UTF_8);){
            JavascriptScannerResult javascriptScannerResult = new Gson().fromJson((Reader)reader, JavascriptScannerResult.class);
            return javascriptScannerResult;
        }
        catch (IOException e) {
            this.log.debug("Error reading from: {}", (Object)packageJsonFile.getPath(), (Object)e);
            return null;
        }
    }
}

