/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.ManifestFileReader;
import com.sonatype.insight.scan.manifest.GoDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class GoModuleProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;
    private final ManifestFileReader manifestFileReader;

    public GoModuleProcessor(FileVisitor fileVisitor, ManifestFileReader manifestFileReader) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
        this.manifestFileReader = manifestFileReader;
    }

    public String process(TFile file) {
        this.log.debug("Processing Go manifest file: {}", (Object)file.getAbsolutePath());
        List<String> lines = this.manifestFileReader.readLines(file);
        Collection<GoDependency> dependencies = this.filterDuplicatesAndRemoveChecksum(lines);
        this.filterSensitiveContent(dependencies);
        return this.toString(new ArrayList<GoDependency>(dependencies));
    }

    private void filterSensitiveContent(Collection<GoDependency> dependencies) {
        Iterator<GoDependency> it = dependencies.iterator();
        while (it.hasNext()) {
            GoDependency dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
            this.log.debug("Not including go dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }

    private String toString(List<GoDependency> dependencies) {
        StringBuilder result = new StringBuilder();
        for (int lineNumber = 0; lineNumber < dependencies.size(); ++lineNumber) {
            GoDependency dependency = dependencies.get(lineNumber);
            result.append(dependency.toString());
            if (lineNumber >= dependencies.size() - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    private Collection<GoDependency> filterDuplicatesAndRemoveChecksum(List<String> lines) {
        LinkedHashSet<GoDependency> filteredDependencies = new LinkedHashSet<GoDependency>();
        for (String line : lines) {
            GoDependency dep = GoDependency.fromGoModString(line);
            if (dep != null) {
                filteredDependencies.add(dep);
                continue;
            }
            this.log.debug("Invalid go.sum entry: {}", (Object)line);
        }
        return filteredDependencies;
    }
}

