/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.io.IOUtils;

public class FileScannerResultProcessor {
    private final Logger log;

    public FileScannerResultProcessor(Logger log) {
        this.log = log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(TFile file) {
        this.log.debug("Processing file: {}", (Object)file.getAbsolutePath());
        try (TFileInputStream inputStream = new TFileInputStream(file);){
            String string = IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

