/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.archive.TFileUtils;
import com.sonatype.insight.scan.file.FileScanRequest;
import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.FileWalker;
import com.sonatype.insight.scan.file.ModuleScanRequest;
import com.sonatype.insight.scan.file.ScanUtils;
import com.sonatype.insight.scan.file.Stats;
import com.sonatype.insight.scan.hash.Digester;
import com.sonatype.insight.scan.model.Dependency;
import com.sonatype.insight.scan.model.ProjectScanItem;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanItemContainer;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ScanWriter;
import java.io.File;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsScheme;

@Named
public class FileScanner {
    private final Logger log;
    private final Anonymizer anonymizer;
    private final Digester digester;
    private Exception simulateExceptionForTests = null;

    @Inject
    public FileScanner(Digester digester, Anonymizer anonymizer) {
        this(digester, anonymizer, LoggerFactory.getLogger(FileScanner.class));
    }

    public FileScanner(Digester digester, Anonymizer anonymizer, Logger log) {
        this.digester = digester;
        this.anonymizer = anonymizer;
        this.log = log;
    }

    public void scan(FileScanRequest request) {
        Scan scan = request.getScanSession().getScan();
        Stats stats = new Stats();
        try {
            if (this.simulateExceptionForTests != null) {
                throw this.simulateExceptionForTests;
            }
            TArchiveDetector detector = this.getArchiveDetector(scan.getConfiguration());
            this.log.debug("Using archive detector {}", (Object)detector);
            this.logScanRequestConfiguration(request);
            FileWalker walker = new FileWalker();
            try (ProgressIndicator progressIndicator = new ProgressIndicator(walker);){
                for (FileScanRequest.FileItem item : request.getFiles()) {
                    this.log.info("{} Starting scanning target: {}", (Object)this.getFormatedCurrentDateTime(), (Object)this.getFilePathForLog(item.file));
                    File file = item.file;
                    if (!this.isNeuVectorContainerFile(file) && !FileUtils.isIacFile(file)) {
                        file = file.getAbsoluteFile();
                    }
                    FileVisitor visitor = new FileVisitor(request.getScanSession(), request.getContainer(), item.path != null ? item.path : FileScanner.getPrefix(file, request.getBasedir()), item.id, false, stats, this.digester, this.anonymizer, this.log);
                    walker.walk(new TFile(file, detector), visitor);
                    this.log.debug("{} Finished scanning target: {}", (Object)this.getFormatedCurrentDateTime(), (Object)this.getFilePathForLog(item.file));
                }
                this.log.info("{} Scanned {} total files", (Object)this.getFormatedCurrentDateTime(), (Object)walker.getFileCount());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.error("Error details:", (Throwable)e);
            stats.errorCount.incrementAndGet();
        }
        this.updateSummary(scan.getSummary(), stats);
    }

    private boolean isNeuVectorContainerFile(File file) {
        return file.getPath().startsWith("container:");
    }

    private String getFormatedCurrentDateTime() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(ZonedDateTime.now());
    }

    private void logScanRequestConfiguration(FileScanRequest request) {
        for (FileScanRequest.FileItem item : request.getFiles()) {
            this.log.info("Scan target: {}", (Object)this.getFilePathForLog(item.file));
        }
        Properties configurationProperties = request.getScanSession().getScan().getConfiguration().getProperties();
        this.log.info("Scan configuration properties:");
        this.log.info("   dirExcludes={}", (Object)configurationProperties.getProperty("dirExcludes"));
        this.log.info("   dirIncludes={}", (Object)configurationProperties.getProperty("dirIncludes"));
        this.log.info("   fileExcludes={}", (Object)configurationProperties.getProperty("fileExcludes"));
        this.log.info("   fileIncludes={}", (Object)configurationProperties.getProperty("fileIncludes"));
    }

    String getFilePathForLog(File file) {
        if (this.isNeuVectorContainerFile(file) || FileUtils.isIacFile(file)) {
            return file.getPath();
        }
        return file.getAbsoluteFile().getPath();
    }

    public void scan(ModuleScanRequest request) {
        Scan scan = request.getScanSession().getScan();
        Stats stats = new Stats();
        try {
            FileVisitor visitor;
            File file;
            if (this.simulateExceptionForTests != null) {
                throw this.simulateExceptionForTests;
            }
            TArchiveDetector detector = this.getArchiveDetector(scan.getConfiguration());
            this.log.debug("Using archive detector {}", (Object)detector);
            ScanWriter writer = request.getScanSession().getScanWriter();
            ProjectScanItem projectItem = new ProjectScanItem(request.getModuleKind(), request.getModuleId());
            String modulePath = ScanUtils.getRelativePath(request.getModuleDir(), request.getBasedir());
            if (modulePath == null && request.getModuleDir() != null) {
                modulePath = request.getModuleDir().getName();
            }
            projectItem.setPath(modulePath);
            for (Map.Entry<String, List<String>> entry : request.getDependencies().entrySet()) {
                String id = entry.getKey();
                boolean direct = request.getDirectDependencies().contains(id);
                Dependency dependency = new Dependency();
                dependency.setId(id);
                dependency.setDirect(direct);
                List<String> childIds = entry.getValue();
                if (childIds != null && !childIds.isEmpty()) {
                    for (String childId : childIds) {
                        Dependency child = new Dependency();
                        child.setId(childId);
                        dependency.addDependency(child);
                    }
                }
                projectItem.addDependency(dependency);
            }
            if (writer == null) {
                scan.addItem((ScanItem)projectItem);
            } else {
                writer.openProjectScanItem(projectItem, request.getModuleDir());
            }
            for (Map.Entry<Object, Object> entry : request.getConsumedFiles().entrySet()) {
                file = (File)entry.getKey();
                String id = (String)entry.getValue();
                visitor = new FileVisitor(request.getScanSession(), (ScanItemContainer)projectItem, file.getName(), id, true, stats, this.digester, this.anonymizer, this.log);
                new FileWalker().walk(new TFile(file, detector), visitor);
            }
            for (Map.Entry<Object, Object> entry : request.getProducedFiles().entrySet()) {
                file = (File)entry.getKey();
                String id = (String)entry.getValue();
                visitor = new FileVisitor(request.getScanSession(), (ScanItemContainer)projectItem, FileScanner.getPrefix(file, request.getBasedir()), id, stats, this.digester, this.anonymizer, this.log);
                new FileWalker().walk(new TFile(file, detector), visitor);
            }
            if (writer != null) {
                writer.closeProjectScanItem(request.getModuleDir());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.error("Error details:", (Throwable)e);
            stats.errorCount.incrementAndGet();
        }
        this.updateSummary(scan.getSummary(), stats);
    }

    private void updateSummary(ScanSummary summary, Stats stats) {
        summary.setArchives(summary.getArchives() + stats.archives.get());
        summary.setDirectories(summary.getDirectories() + stats.directories.get());
        summary.setFiles(summary.getFiles() + stats.files.get());
        summary.setClassFiles(summary.getClassFiles() + stats.classFiles.get());
        summary.setInaccessibleFiles(summary.getInaccessibleFiles() + stats.inaccessibleFiles.get());
        summary.setErrorCount(summary.getErrorCount() + stats.errorCount.get());
    }

    private TArchiveDetector getArchiveDetector(ScanConfiguration config) {
        HashMap<TFileUtils.Driver, String> driverMappings = new HashMap<TFileUtils.Driver, String>();
        for (TFileUtils.Driver driver : TFileUtils.Driver.values()) {
            driverMappings.put(driver, config.getString(null, new String[]{driver.name().toLowerCase(Locale.ENGLISH)}));
        }
        TreeSet<String> badExtensions = new TreeSet<String>();
        TArchiveDetector detector = TFileUtils.getArchiveDetector(driverMappings, badExtensions);
        if (!badExtensions.isEmpty()) {
            this.log.warn("Ignored invalid file extensions {}", badExtensions);
        }
        return detector;
    }

    static String getPrefix(File file, File basedir) {
        String prefix;
        if (file == null) {
            return null;
        }
        String string = prefix = basedir != null ? ScanUtils.getRelativePath(file, basedir) : null;
        if (prefix == null) {
            prefix = file.getName();
        }
        return prefix;
    }

    public Set<String> getSupportedArchiveTypes(ScanConfiguration configuration) {
        TArchiveDetector detector = this.getArchiveDetector(configuration);
        TreeSet<String> extensions = new TreeSet<String>();
        for (Map.Entry<FsScheme, FsDriver> entry : detector.get().entrySet()) {
            extensions.add(entry.getKey().toString());
        }
        extensions.remove("file");
        extensions.remove("exe");
        return extensions;
    }

    public void setSimulateExceptionForTests(Exception simulateExceptionForTests) {
        this.simulateExceptionForTests = simulateExceptionForTests;
    }

    private class ProgressIndicator
    implements AutoCloseable {
        private final Timer progressTimer = new Timer(this.getClass().getSimpleName(), true);

        ProgressIndicator(final FileWalker fileWalker) {
            this.progressTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    FileScanner.this.log.info("{} Scanned {} files so far", (Object)FileScanner.this.getFormatedCurrentDateTime(), (Object)fileWalker.getFileCount());
                }
            }, 5000L, 5000L);
        }

        @Override
        public void close() throws Exception {
            this.progressTimer.cancel();
        }
    }
}

