/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.ManifestFileReader;
import com.sonatype.insight.scan.manifest.ConanDependency;
import com.sonatype.insight.scan.manifest.ConanDependencyCategory;
import com.sonatype.insight.scan.manifest.ConanFile;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class ConanFileProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;
    private final ManifestFileReader manifestFileReader;

    public ConanFileProcessor(FileVisitor fileVisitor, ManifestFileReader manifestFileReader) {
        this.log = fileVisitor.log;
        this.fileVisitor = fileVisitor;
        this.manifestFileReader = manifestFileReader;
    }

    public String process(TFile file) {
        this.log.debug("Processing Conanfile: {}", (Object)file.getAbsolutePath());
        List<String> lines = this.manifestFileReader.readLines(file);
        this.removeCommentsAndEmptyLines(lines);
        ConanFile conanFile = ConanFile.fromFileContents(lines);
        this.filterSensitiveContent(conanFile);
        return this.toString(conanFile);
    }

    private void removeCommentsAndEmptyLines(List<String> lines) {
        ListIterator<String> it = lines.listIterator();
        while (it.hasNext()) {
            int commentIndex;
            String line = it.next();
            if (line != null && (commentIndex = (line = line.trim()).indexOf("#")) >= 0) {
                line = line.substring(0, commentIndex);
                line = line.trim();
                it.set(line);
            }
            if (line != null && !line.isEmpty()) continue;
            it.remove();
        }
    }

    public void filterSensitiveContent(ConanFile conanFile) {
        this.filterContentFromDependencyList(conanFile.requires);
        this.filterContentFromDependencyList(conanFile.buildRequires);
        this.filterContentFromDependencyList(conanFile.fullRequires);
        this.filterContentFromList(conanFile.generators);
        this.filterContentFromList(conanFile.imports);
        this.filterContentFromList(conanFile.options);
    }

    private void filterContentFromDependencyList(List<ConanDependency> dependencies) {
        Iterator<ConanDependency> it = dependencies.iterator();
        while (it.hasNext()) {
            ConanDependency dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency.name)) continue;
            this.log.debug("Not including conan dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }

    private void filterContentFromList(List<String> dependencies) {
        Iterator<String> it = dependencies.iterator();
        while (it.hasNext()) {
            String dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency)) continue;
            this.log.debug("Not including conan dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }

    private String toString(ConanFile conanFile) {
        StringBuilder builder = new StringBuilder();
        if (!conanFile.requires.isEmpty()) {
            builder.append(ConanDependencyCategory.REQUIRES.categoryMarker).append('\n');
            for (ConanDependency dependency : conanFile.requires) {
                builder.append(dependency.getConanDependencyString()).append('\n');
            }
        }
        if (!conanFile.buildRequires.isEmpty()) {
            builder.append(ConanDependencyCategory.BUILD_REQUIRES.categoryMarker).append('\n');
            for (ConanDependency dependency : conanFile.buildRequires) {
                builder.append(dependency.getConanDependencyString()).append('\n');
            }
        }
        if (!conanFile.fullRequires.isEmpty()) {
            builder.append(ConanDependencyCategory.FULL_REQUIRES.categoryMarker).append('\n');
            for (ConanDependency dependency : conanFile.fullRequires) {
                builder.append(dependency.getConanDependencyString()).append('\n');
            }
        }
        this.appendDependencySection(builder, conanFile.generators, ConanDependencyCategory.GENERATORS);
        this.appendDependencySection(builder, conanFile.options, ConanDependencyCategory.OPTIONS);
        this.appendDependencySection(builder, conanFile.imports, ConanDependencyCategory.IMPORTS);
        return builder.toString();
    }

    private void appendDependencySection(StringBuilder builder, List<String> generators, ConanDependencyCategory generators2) {
        if (!generators.isEmpty()) {
            builder.append(generators2.categoryMarker).append('\n');
            for (String generator : generators) {
                builder.append(generator.trim()).append('\n');
            }
        }
    }
}

