/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.json.store;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import zz.com.fasterxml.jackson.core.JsonEncoding;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.TreeNode;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.MappingJsonFactory;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.ContainerNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.node.NullNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;

public final class JsonUtils {
    private static final MappingJsonFactory JSON = new MappingJsonFactory();

    public static ObjectNode stamp(String user, String ip, String where, ContainerNode<?> data) {
        ObjectNode stampedData = JsonUtils.objectNode(data);
        stampedData.put("time", System.currentTimeMillis());
        stampedData.put("user", user);
        stampedData.put("ip", ip);
        stampedData.put("where", where);
        stampedData.set("data", data);
        return stampedData;
    }

    public static <T extends ContainerNode<?>> T read(File file) throws IOException {
        try (JsonParser parser = JSON.createParser(file);){
            ContainerNode containerNode = (ContainerNode)parser.readValueAsTree();
            return (T)containerNode;
        }
    }

    public static <T> T read(File file, Class<? extends T> type) throws IOException {
        try (JsonParser parser = JSON.createParser(file);){
            T t = parser.readValueAs(type);
            return t;
        }
    }

    public static void write(File file, JsonNode data) throws IOException {
        Files.createDirectories(file.getAbsoluteFile().getParentFile().toPath(), new FileAttribute[0]);
        try (JsonGenerator generator = JSON.createGenerator(file, JsonEncoding.UTF8);){
            generator.useDefaultPrettyPrinter().writeTree(data);
        }
    }

    public static void write(File file, Object pojo) throws IOException {
        Files.createDirectories(file.getAbsoluteFile().getParentFile().toPath(), new FileAttribute[0]);
        try (JsonGenerator generator = JSON.createGenerator(file, JsonEncoding.UTF8);){
            generator.useDefaultPrettyPrinter().writeObject(pojo);
        }
    }

    public static <T extends ContainerNode<?>> T parse(byte[] buf) throws IOException {
        try (JsonParser parser = JSON.createParser(buf);){
            ContainerNode containerNode = (ContainerNode)parser.readValueAsTree();
            return (T)containerNode;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T parse(byte[] buf, Class<? extends T> type) throws IOException {
        Throwable throwable = null;
        try (JsonParser parser = JSON.createParser(buf);){
            T t = parser.readValueAs(type);
            return t;
        }
        catch (JsonMappingException e) {
            T t;
            if (!type.isArray()) throw e;
            try {
                t = JSON.getCodec().reader().withRootName("aaData").readValue(parser, type);
            }
            catch (JsonMappingException jsonMappingException) {
                try {
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return t;
        }
    }

    public static <T extends ContainerNode<?>> T parse(String json) throws IOException {
        return JsonUtils.parse(json.getBytes(StandardCharsets.UTF_8));
    }

    public static <T> T parse(String json, Class<? extends T> type) throws IOException {
        return JsonUtils.parse(json.getBytes(StandardCharsets.UTF_8), type);
    }

    public static <T> T parse(InputStream stream, Class<? extends T> type) throws IOException {
        try (JsonParser parser = JSON.createParser(stream);){
            T t = parser.readValueAs(type);
            return t;
        }
    }

    public static byte[] generate(JsonNode data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonGenerator generator = JSON.createGenerator(os, JsonEncoding.UTF8);){
            generator.useDefaultPrettyPrinter().writeTree(data);
        }
        return os.toByteArray();
    }

    public static byte[] generate(Object pojo) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonGenerator generator = JSON.createGenerator(os, JsonEncoding.UTF8);){
            generator.useDefaultPrettyPrinter().writeObject(pojo);
        }
        return os.toByteArray();
    }

    public static String format(Object pojo) {
        try {
            return new String(JsonUtils.generate(pojo), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String writeUnformatted(Object pojo) {
        try {
            return JSON.getCodec().writeValueAsString(pojo);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T extends ContainerNode<?>> T asTree(Object pojo) {
        return (T)((ContainerNode)JSON.getCodec().valueToTree(pojo));
    }

    public static <T> T asPojo(JsonNode tree, Class<? extends T> type) throws IOException {
        return JSON.getCodec().treeToValue((TreeNode)tree, type);
    }

    public static ArrayNode arrayNode(ContainerNode<?> data) {
        return data != null ? data.arrayNode() : JsonNodeFactory.instance.arrayNode();
    }

    public static ObjectNode objectNode(ContainerNode<?> data) {
        return data != null ? data.objectNode() : JsonNodeFactory.instance.objectNode();
    }

    public static ObjectNode aaDataNode(Iterable<JsonNode> data) {
        ArrayNode aaData = JsonNodeFactory.instance.arrayNode();
        for (JsonNode d : data) {
            aaData.add(d);
        }
        return (ObjectNode)aaData.objectNode().set("aaData", aaData);
    }

    public static <T> Object aaData(Iterable<T> data) {
        return Collections.singletonMap("aaData", data);
    }

    public static Float getNullableFloat(JsonNode jsonNode) {
        if (JsonUtils.isNull(jsonNode)) {
            return null;
        }
        return Float.valueOf((float)jsonNode.asDouble());
    }

    public static String getNullableString(JsonNode jsonNode) {
        if (JsonUtils.isNull(jsonNode)) {
            return null;
        }
        return jsonNode.asText();
    }

    public static boolean isNull(JsonNode jsonNode) {
        return jsonNode == null || jsonNode instanceof NullNode;
    }

    public static List<String> getStringListFromArray(JsonNode jsonNode) {
        if (JsonUtils.isNull(jsonNode)) {
            return null;
        }
        ArrayNode jsonArray = (ArrayNode)jsonNode;
        if (jsonArray.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (JsonNode child : jsonArray) {
            if (child.isNull()) continue;
            result.add(child.asText());
        }
        return result;
    }

    public static Set<String> getStringSetFromArray(JsonNode arrayNode) {
        if (arrayNode != null && arrayNode.isArray() && !arrayNode.isEmpty()) {
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            for (JsonNode jsonNode : arrayNode) {
                String result;
                if (jsonNode == null || jsonNode.isNull() || (result = jsonNode.asText()) == null) continue;
                results.add(jsonNode.asText());
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public static String getTypeToString(JsonNode jsonNode, Class<?> type) {
        try {
            return JsonUtils.asPojo(jsonNode, type).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public static <T> Set<T> getObjectSetFromArray(JsonNode arrayNode, Class<T> type) {
        if (arrayNode != null && arrayNode.isArray() && !arrayNode.isEmpty()) {
            LinkedHashSet<T> results = new LinkedHashSet<T>();
            for (JsonNode jsonNode : arrayNode) {
                T result;
                if (jsonNode == null || jsonNode.isNull()) continue;
                try {
                    result = JsonUtils.asPojo(jsonNode, type);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (result == null) continue;
                results.add(result);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    static {
        JSON.getCodec().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JSON.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
    }
}

