/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import com.sonatype.insight.client.utils.Authentication;

public class SimpleAuthentication
implements Authentication {
    private String username;
    private char[] password;
    private String ntlmDomain;
    private String ntlmWorkstation;

    private static char[] toChars(String str) {
        return str != null ? str.toCharArray() : null;
    }

    private static char[] clone(char[] chars) {
        return chars != null ? (char[])chars.clone() : null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public char[] getPassword() {
        return SimpleAuthentication.clone(this.password);
    }

    public void setPassword(char[] password) {
        this.password = SimpleAuthentication.clone(password);
    }

    public void setPassword(String password) {
        this.password = SimpleAuthentication.toChars(password);
    }

    public void setUsernamePassword(String credentials) {
        String user = null;
        char[] pass = null;
        if (credentials != null && !credentials.isEmpty()) {
            int colon = credentials.indexOf(58);
            if (colon < 0) {
                user = credentials;
            } else {
                user = credentials.substring(0, colon);
                pass = credentials.substring(colon + 1).toCharArray();
            }
        }
        this.username = user;
        this.password = pass;
    }

    @Override
    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    @Override
    public String getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public void setNtlmWorkstation(String ntlmWorkstation) {
        this.ntlmWorkstation = ntlmWorkstation;
    }

    public static SimpleAuthentication parse(String credentials) {
        if (credentials != null && !credentials.isEmpty()) {
            SimpleAuthentication auth = new SimpleAuthentication();
            auth.setUsernamePassword(credentials);
            return auth;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
        }
        this.password = null;
    }
}

