/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import com.sonatype.insight.client.utils.Authentication;
import com.sonatype.insight.client.utils.HttpRequestExecutor;
import com.sonatype.insight.client.utils.InMemoryAuthCache;
import com.sonatype.insight.client.utils.PkiAuthentication;
import com.sonatype.insight.client.utils.ProxyExcludeHostsRoutePlanner;
import com.sonatype.insight.client.utils.UserAgentUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientUtils {
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 900000;
    static final String AUTH_SCHEME_ORDER_PROPERTY = "http.auth.schemeOrder";
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);

    private HttpClientUtils() {
    }

    public static HttpContext createPreemptiveAuthContext(HttpHost host) {
        InMemoryAuthCache authCache = new InMemoryAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(host, (AuthScheme)basicAuth);
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setAuthCache((AuthCache)authCache);
        return clientContext;
    }

    static List<String> getAuthSchemeOrder() {
        String schemeOrderOverride = System.getProperty(AUTH_SCHEME_ORDER_PROPERTY, "");
        ArrayList<String> schemeOrder = new ArrayList<String>(Arrays.asList(schemeOrderOverride.split("[\\s,]+")));
        schemeOrder.remove("");
        if (schemeOrder.isEmpty()) {
            schemeOrder = null;
        }
        return schemeOrder;
    }

    public static HttpClientBuilder create(Configuration request) {
        List<String> schemeOrder = HttpClientUtils.getAuthSchemeOrder();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(request.getConnectTimeout()).setSocketTimeout(request.getSocketTimeout()).setRedirectsEnabled(request.isRedirectsEnabled()).setTargetPreferredAuthSchemes(schemeOrder).setProxyPreferredAuthSchemes(schemeOrder);
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(request.getConnectTimeout()).build();
        HttpHost host = URIUtils.extractHost((URI)URI.create(request.getServerUrl()));
        if (host == null) {
            throw new IllegalArgumentException("Invalid URL: " + request.getServerUrl());
        }
        Authentication serverAuth = request.getServerAuth();
        if (serverAuth != null && serverAuth.getUsername() != null) {
            HttpClientUtils.setAuthentication((CredentialsProvider)credentialsProvider, host, serverAuth);
        }
        ProxyExcludeHostsRoutePlanner proxyExcludeRoutePlanner = null;
        String proxyHost = request.getProxyHost();
        if (proxyHost != null && !proxyHost.isEmpty()) {
            HttpHost proxy = new HttpHost(proxyHost, request.getProxyPort());
            proxyExcludeRoutePlanner = new ProxyExcludeHostsRoutePlanner(proxy, request.getProxyExcludeHosts());
            Authentication proxyAuth = request.getProxyAuth();
            if (proxyAuth != null && proxyAuth.getUsername() != null) {
                HttpClientUtils.setAuthentication((CredentialsProvider)credentialsProvider, proxy, proxyAuth);
            }
        }
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfigBuilder.build()).setDefaultSocketConfig(socketConfig).setUserAgent(request.getUserAgent()).setRequestExecutor((org.apache.http.protocol.HttpRequestExecutor)new HttpRequestExecutor(request.getUserAgent())).useSystemProperties();
        if (proxyExcludeRoutePlanner != null) {
            builder.setRoutePlanner((HttpRoutePlanner)proxyExcludeRoutePlanner);
        }
        if (request.getPkiAuth() != null) {
            builder.setSSLContext(HttpClientUtils.createSslContext(request.getPkiAuth()));
        }
        if (!request.isRedirectsEnabled()) {
            builder.disableRedirectHandling();
        }
        return builder;
    }

    private static SSLContext createSslContext(PkiAuthentication pkiAuthentication) {
        try {
            return SSLContexts.custom().loadKeyMaterial(pkiAuthentication.getKeyStore(), pkiAuthentication.getKeyPassword()).build();
        }
        catch (GeneralSecurityException e) {
            log.warn("Failed to create SSL context.", (Throwable)e);
            return SSLContexts.createSystemDefault();
        }
    }

    public static HttpResponse cacheEntity(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ByteArrayEntity copy = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)entity));
            copy.setChunked(entity.isChunked());
            copy.setContentEncoding(entity.getContentEncoding());
            copy.setContentType(entity.getContentType());
            response.setEntity((HttpEntity)copy);
        }
        return response;
    }

    private static void setAuthentication(CredentialsProvider credentialsProvider, HttpHost host, Authentication auth) {
        String workstation;
        String domain;
        char[] charPassword;
        String username = auth.getUsername();
        if (username == null || username.isEmpty()) {
            username = System.getProperty("user.name");
        }
        String password = (charPassword = auth.getPassword()) == null ? "" : new String(charPassword);
        AuthScope authScope = new AuthScope(host.getHostName(), host.getPort());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        int backslash = username.indexOf(92);
        if (backslash < 0) {
            domain = auth.getNtlmDomain();
            if (domain == null) {
                domain = HttpClientUtils.guessNtmlDomain();
            }
        } else {
            domain = username.substring(0, backslash);
            username = username.substring(backslash + 1);
        }
        if ((workstation = auth.getNtlmWorkstation()) == null) {
            workstation = HttpClientUtils.guessNtlmWorkstation();
        }
        authScope = new AuthScope(host.getHostName(), host.getPort(), null, "NTLM");
        credentials = new NTCredentials(username, password, workstation, domain);
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
    }

    private static String guessNtmlDomain() {
        return HttpClientUtils.safeNtlmString(System.getProperty("http.auth.ntlm.domain"), System.getenv("USERDOMAIN"));
    }

    private static String guessNtlmWorkstation() {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return HttpClientUtils.safeNtlmString(System.getProperty("http.auth.ntlm.host"), System.getenv("COMPUTERNAME"), localHost);
    }

    private static String safeNtlmString(String ... strings) {
        for (String string : strings) {
            if (string == null) continue;
            return string;
        }
        return "";
    }

    public static interface HttpClientProvider {
        public HttpClientBuilder create(Configuration var1);
    }

    public static class Configuration {
        private static final HttpClientProvider DEFAULT_HTTP_CLIENT_PROVIDER = new HttpClientProvider(){

            @Override
            public HttpClientBuilder create(Configuration config) {
                return HttpClientUtils.create(config);
            }
        };
        private String serverUrl;
        private String serverAdminUrl;
        private Authentication serverAuth;
        private PkiAuthentication pkiAuth;
        private String proxyHost;
        private int proxyPort = 80;
        private List<String> proxyExcludeHosts;
        private Authentication proxyAuth;
        private String userAgent;
        private HttpClientProvider httpClientProvider = DEFAULT_HTTP_CLIENT_PROVIDER;
        private int socketTimeout = 900000;
        private int connectTimeout = 60000;
        private boolean redirectsEnabled = true;

        public String getServerUrl() {
            return this.serverUrl;
        }

        public void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public void setServerAdminUrl(String serverAdminUrl) {
            this.serverAdminUrl = serverAdminUrl;
        }

        public Authentication getServerAuth() {
            return this.serverAuth;
        }

        public void setServerAuth(Authentication serverAuth) {
            this.serverAuth = serverAuth;
        }

        public void setPkiAuth(PkiAuthentication pkiAuth) {
            this.pkiAuth = pkiAuth;
        }

        public PkiAuthentication getPkiAuth() {
            return this.pkiAuth;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public void setProxy(String proxy) {
            String pHost = null;
            int pPort = 80;
            if (proxy != null && !proxy.isEmpty()) {
                int colon = proxy.lastIndexOf(58);
                if (colon < 0) {
                    pHost = proxy;
                } else {
                    pHost = proxy.substring(0, colon);
                    try {
                        pPort = Integer.parseInt(proxy.substring(colon + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.setProxyHost(pHost);
            this.setProxyPort(pPort);
        }

        public void setProxyExcludeHosts(List<String> proxyExcludeHosts) {
            this.proxyExcludeHosts = proxyExcludeHosts;
        }

        public List<String> getProxyExcludeHosts() {
            return this.proxyExcludeHosts == null ? Collections.emptyList() : this.proxyExcludeHosts;
        }

        public Authentication getProxyAuth() {
            return this.proxyAuth;
        }

        public void setProxyAuth(Authentication proxyAuth) {
            this.proxyAuth = proxyAuth;
        }

        public String getUserAgent() {
            if (this.userAgent == null) {
                return UserAgentUtils.getDefaultUserAgent();
            }
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String getServerAdminUrl() {
            return this.serverAdminUrl;
        }

        public HttpClientProvider getHttpClientProvider() {
            return this.httpClientProvider;
        }

        public void setHttpClientProvider(HttpClientProvider httpClientProvider) {
            this.httpClientProvider = httpClientProvider;
            if (this.httpClientProvider == null) {
                this.httpClientProvider = DEFAULT_HTTP_CLIENT_PROVIDER;
            }
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public boolean isRedirectsEnabled() {
            return this.redirectsEnabled;
        }

        public void setRedirectsEnabled(boolean redirectsEnabled) {
            this.redirectsEnabled = redirectsEnabled;
        }

        public HttpClientBuilder createClientBuilder() {
            return this.httpClientProvider.create(this);
        }
    }
}

