/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationResult;
import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.brain.client.ErrorData;
import com.sonatype.insight.brain.client.ResultData;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.client.utils.UrlUtils;
import com.sonatype.insight.json.store.JsonUtils;
import com.sonatype.insight.scan.model.ClientScanType;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;

public class ScanClient
extends AbstractRequestClient {
    private static final ContentType GZIP_CONTENT_TYPE = ContentType.create((String)"application/x-gzip");
    private final String serverUrl;
    private final String appId;

    public ScanClient(HttpClientUtils.Configuration config, String appId) {
        super(config);
        this.serverUrl = config.getServerUrl();
        this.appId = UrlUtils.encodeUrlComponent(appId);
    }

    public ScanReceipt uploadCLIScan(File scanFile, ClientScanType clientScanType) throws IOException {
        return this.handleUpload("rest/cli/scan", scanFile, clientScanType);
    }

    private ScanReceipt handleUpload(String url, File scanFile, ClientScanType clientScanType) throws IOException {
        Object result = this.path(url, this.appId).query("scanType", clientScanType.name()).put((HttpEntity)new FileEntity(scanFile, GZIP_CONTENT_TYPE));
        return this.parseResult((Result)result, ScanReceipt.class);
    }

    public void saveResultData(File resultFile, ScanReceipt receipt, PolicyEvaluationResult eval, String outcome) throws IOException {
        ResultData resultData = new ResultData();
        resultData.applicationId = this.appId;
        resultData.scanId = receipt.getScanId();
        resultData.reportHtmlUrl = receipt.resolveReportUrl(this.serverUrl);
        resultData.reportPdfUrl = receipt.resolvePdfUrl(this.serverUrl);
        resultData.reportDataUrl = receipt.resolveDataUrl(this.serverUrl);
        resultData.policyEvaluationResult = eval;
        resultData.policyAction = outcome;
        JsonUtils.write(resultFile, resultData);
    }

    public void saveErrorData(File errorFile, String errorMessage, boolean isSystemError) throws IOException {
        ErrorData errorData = new ErrorData();
        errorData.errorMessage = errorMessage;
        errorData.isSystemError = isSystemError;
        JsonUtils.write(errorFile, errorData);
    }
}

