/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationPollingResult;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationReceipt;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationStatus;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationSummary;
import com.sonatype.clm.dto.model.policy.Stage;
import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.brain.client.SourceControlClient;
import com.sonatype.insight.client.utils.AbstractClientBuilder;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.client.utils.UrlUtils;
import com.sonatype.insight.scan.model.ClientScanResult;
import com.sonatype.insight.scan.model.ClientScanType;
import com.sonatype.nexus.git.utils.repository.RepositoryUrlFinderBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyClient
extends AbstractRequestClient {
    private static final ContentType GZIP_CONTENT_TYPE = ContentType.create((String)"application/x-gzip");
    private static final String CLI_INTEGRATION_PATH = "cli";
    private static final String CI_INTEGRATION_PATH = "ci";
    private static final String REPOSITORY_MANAGER_INTEGRATION_PATH = "rm";
    private final Logger log;
    private final String serverUrl;
    protected final String appId;
    private final SourceControlClient sourceControlClient;

    public PolicyClient(HttpClientUtils.Configuration config, String appId) {
        this(config, appId, null);
    }

    public PolicyClient(HttpClientUtils.Configuration config, String appId, Logger log) {
        super(config);
        this.log = log != null ? log : LoggerFactory.getLogger(PolicyClient.class);
        this.serverUrl = config.getServerUrl();
        this.appId = UrlUtils.encodeUrlComponent(appId);
        this.sourceControlClient = new SourceControlClient(config);
    }

    public PolicyEvaluationPollingResult evaluateCLI(ClientScanResult clientScanResult, ClientScanType clientScanType, Stage stage) throws IOException {
        return this.evaluate(CLI_INTEGRATION_PATH, clientScanResult.getScanFile(), this.getClientScanType(clientScanResult, clientScanType), stage);
    }

    public PolicyEvaluationPollingResult evaluateCI(ClientScanResult clientScanResult, Stage stage) throws IOException {
        return this.evaluate(CI_INTEGRATION_PATH, clientScanResult.getScanFile(), this.getClientScanType(clientScanResult, ClientScanType.SONATYPE), stage);
    }

    private ClientScanType getClientScanType(ClientScanResult clientScanResult, ClientScanType clientScanType) {
        if (clientScanResult.hasThirdPartyScanContent()) {
            return ClientScanType.SONATYPE_THIRD_PARTY;
        }
        return clientScanType;
    }

    public PolicyEvaluationPollingResult evaluateRepoMan(File scanFile, Stage stage) throws IOException {
        return this.evaluate(REPOSITORY_MANAGER_INTEGRATION_PATH, scanFile, ClientScanType.SONATYPE, stage);
    }

    PolicyEvaluationPollingResult evaluate(String integrationPath, File scanFile, ClientScanType clientScanType, Stage stage) throws IOException {
        if (CLI_INTEGRATION_PATH.equals(integrationPath)) {
            this.addOrUpdateSourceControl();
        }
        FileEntity entity = new FileEntity(scanFile, GZIP_CONTENT_TYPE);
        long start = System.currentTimeMillis();
        Result evaluateResult = this.evaluateResult(integrationPath, clientScanType, stage, (HttpEntity)entity);
        PolicyEvaluationReceipt receipt = this.parseResult(evaluateResult, PolicyEvaluationReceipt.class);
        this.beforePolling(receipt, integrationPath);
        this.log.debug("Assigned status ID {}", (Object)receipt.getStatusId());
        this.log.info("Waiting for policy evaluation to complete...");
        PolicyEvaluationPollingResult result = this.pollEvaluationResult(receipt.getStatusId());
        this.log.info("Policy evaluation completed in {} seconds.", (Object)((System.currentTimeMillis() - start) / 1000L));
        return result;
    }

    protected Result evaluateResult(String integrationPath, ClientScanType clientScanType, Stage stage, HttpEntity entity) throws IOException {
        return this.evaluationRequestPathBuilder(integrationPath, clientScanType, stage).post(entity);
    }

    protected AbstractClientBuilder.RequestBuilder evaluationRequestPathBuilder(String integrationPath, ClientScanType clientScanType, Stage stage) {
        return this.path("rest/integration/applications/", this.appId, "/evaluations/", integrationPath, "/stages/", stage.getStageTypeId()).query("scanType", clientScanType.name());
    }

    protected void beforePolling(PolicyEvaluationReceipt receipt, String integrationPath) throws IOException {
    }

    private void addOrUpdateSourceControl() {
        try {
            Optional<String> optional = new RepositoryUrlFinderBuilder().withEnvironmentVariableDefault().withEnvironmentVariableNamed("CI_PROJECT_URL").withGitRepo().build().tryGetRepositoryUrl();
            if (optional.isPresent()) {
                String repositoryUrl = optional.get();
                this.log.debug("Amending source control record for application with id: {} with discovered repository URL", (Object)this.appId);
                this.sourceControlClient.addOrUpdateSourceControlRecord(this.appId, repositoryUrl);
            } else {
                this.log.debug("Repository URL for application with id: {} could not be found.", (Object)this.appId);
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to add or update the source control record due to:", (Throwable)e);
        }
    }

    private PolicyEvaluationPollingResult pollEvaluationResult(String statusId) throws IOException {
        PolicyEvaluationPollingResult pollingStatus;
        ScanReceipt scanReceipt = null;
        do {
            this.log.debug("Checking evaluation status at {}", (Object)new Date());
            Object pollingResult = this.path("rest/integration/applications/", this.appId, "/evaluations/status/", statusId).get();
            pollingStatus = this.parseResult((Result)pollingResult, PolicyEvaluationPollingResult.class);
            if (scanReceipt == null && pollingStatus.getScanReceipt() != null) {
                scanReceipt = pollingStatus.getScanReceipt();
                this.log.info("Assigned scan ID {}", (Object)scanReceipt.getScanId());
            }
            if (!pollingStatus.getStatus().equals((Object)PolicyEvaluationStatus.PENDING)) continue;
            try {
                Thread.sleep(pollingStatus.getNextPollingIntervalInSeconds() * 1000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Policy evaluation interrupted.", e);
            }
        } while (PolicyEvaluationStatus.PENDING.equals((Object)pollingStatus.getStatus()));
        if (pollingStatus.getStatus().equals((Object)PolicyEvaluationStatus.FAILED)) {
            throw new IOException("Policy evaluation could not be completed: " + pollingStatus.getReason());
        }
        return pollingStatus;
    }

    public String linkToManagement() {
        return UrlUtils.appendUrlPaths(this.serverUrl, "ui/links/application", this.appId, "management");
    }

    public PolicyEvaluationSummary getPolicyEvaluationSummary(Stage stage) throws IOException {
        Object result = this.path("rest/quality/evaluations/", this.appId, "/", stage.getStageTypeId()).get();
        return this.parseResult((Result)result, PolicyEvaluationSummary.class);
    }
}

