/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.component.ProprietaryComponentNames;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.component.UnquarantinedComponentList;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.QuarantinedComponentReport;
import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.json.store.JsonUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

public class FirewallClient
extends AbstractRequestClient {
    public static final String NEXUS_RESOURCE_PATH = "rest/integration/repositories";
    public static final String ARTIFACTORY_RESOURCE_PATH = "rest/integration/artifactory/repositories";
    private static final String EVALUATE_PATH = "evaluate/audit";
    private static final String EVALUATE_COMPONENTS_ADHOC_PATH = "evaluate/adhoc";
    private static final String SUMMARY_PATH = "summary";
    private static final String ENABLE_PATH = "enable";
    private static final String QUARANTINE_PATH = "quarantine";
    private static final String COMPONENTS_PATH = "components";
    private static final String UNQUARANTINED_COMPONENTS_PATH = "components/unquarantined";
    private static final String EVALUATE_COMPONENT_WITH_QUARANTINE_PATH = "evaluate/quarantine";
    private static final String EVALUATE_COMPONENT_METADATA_PATH = "evaluate/componentMetadata";
    private static final String PROPRIETARY_NAMES_PATH = "proprietary/names";
    static final String QUARANTINED_COMPONENT_REPORT_URL_PATH = "quarantinedComponentReportUrl";
    private final String repositoryManagerInstanceId;
    private final String repositoryPublicId;
    private final String resourcePath;

    public FirewallClient(HttpClientUtils.Configuration config, String repositoryManagerInstanceId, String repositoryPublicId, String resourcePath) {
        super(config);
        this.repositoryManagerInstanceId = repositoryManagerInstanceId;
        this.repositoryPublicId = repositoryPublicId;
        this.resourcePath = resourcePath;
    }

    public void setEnabled(boolean enabled) throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, ENABLE_PATH, Boolean.toString(enabled)).post(null);
        this.verifyStatusCode((Result)result);
    }

    public void setQuarantine(boolean enabled) throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, QUARANTINE_PATH, Boolean.toString(enabled)).post(null);
        this.verifyStatusCode((Result)result);
    }

    public void removeComponent(String pathname) throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, COMPONENTS_PATH, pathname).delete();
        this.verifyStatusCode((Result)result);
    }

    public void evaluateComponents(RepositoryComponentEvaluationDataRequestList componentEvaluationDataRequestList) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(JsonUtils.generate(componentEvaluationDataRequestList), ContentType.APPLICATION_JSON);
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, EVALUATE_PATH).post((HttpEntity)entity);
        this.verifyStatusCode((Result)result);
    }

    public RepositoryComponentEvaluationDataList evaluateComponentsAdhoc(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(JsonUtils.generate(repositoryComponentEvaluationDataRequestList), ContentType.APPLICATION_JSON);
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, EVALUATE_COMPONENTS_ADHOC_PATH).post((HttpEntity)entity);
        this.verifyStatusCode((Result)result);
        return this.parseResult((Result)result, RepositoryComponentEvaluationDataList.class);
    }

    public RepositoryComponentEvaluationDataList evaluateComponentWithQuarantine(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(JsonUtils.generate(repositoryComponentEvaluationDataRequestList), ContentType.APPLICATION_JSON);
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, EVALUATE_COMPONENT_WITH_QUARANTINE_PATH).post((HttpEntity)entity);
        return this.parseResult((Result)result, RepositoryComponentEvaluationDataList.class);
    }

    public RepositoryComponentEvaluationDataList evaluateComponentMetadata(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(JsonUtils.generate(repositoryComponentEvaluationDataRequestList), ContentType.APPLICATION_JSON);
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, EVALUATE_COMPONENT_METADATA_PATH).post((HttpEntity)entity);
        return this.parseResult((Result)result, RepositoryComponentEvaluationDataList.class);
    }

    public RepositoryPolicyEvaluationSummary getPolicyEvaluationSummary() throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, SUMMARY_PATH).get();
        return this.parseResult((Result)result, RepositoryPolicyEvaluationSummary.class);
    }

    public UnquarantinedComponentList getUnquarantinedComponents(long sinceUtcTimestamp) throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, UNQUARANTINED_COMPONENTS_PATH).query("sinceUtcTimestamp", Long.toString(sinceUtcTimestamp)).get();
        return this.parseResult((Result)result, UnquarantinedComponentList.class);
    }

    public void addProprietaryComponentNames(ProprietaryComponentNames proprietaryComponentNames) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(JsonUtils.generate(proprietaryComponentNames), ContentType.APPLICATION_JSON);
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, PROPRIETARY_NAMES_PATH).post((HttpEntity)entity);
        this.verifyStatusCode((Result)result);
    }

    public QuarantinedComponentReport getQuarantinedComponentReport(String pathname) throws IOException {
        Object result = this.path(this.resourcePath, this.repositoryManagerInstanceId, this.repositoryPublicId, COMPONENTS_PATH, pathname, QUARANTINED_COMPONENT_REPORT_URL_PATH).get();
        return this.parseResult((Result)result, QuarantinedComponentReport.class);
    }
}

