/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.sonatype.clm.dto.model.policy.ConditionFact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConstraintFact {
    private String constraintId;
    private String constraintName;
    private String operatorName;
    private List<ConditionFact> conditionFacts;

    public ConstraintFact() {
    }

    public ConstraintFact(String constraintId, String constraintName, String operatorName) {
        this.constraintId = constraintId;
        this.constraintName = constraintName;
        this.operatorName = operatorName;
    }

    public ConstraintFact(String constraintId, String constraintName, String operatorName, ConditionFact ... conditionFacts) {
        this(constraintId, constraintName, operatorName);
        this.conditionFacts = Arrays.asList(conditionFacts);
    }

    public String getConstraintId() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public List<ConditionFact> getConditionFacts() {
        return this.conditionFacts != null ? Collections.unmodifiableList(this.conditionFacts) : Collections.emptyList();
    }

    public void addConditionFact(ConditionFact conditionFact) {
        if (this.conditionFacts == null) {
            this.conditionFacts = new ArrayList<ConditionFact>();
        }
        this.conditionFacts.add(conditionFact);
    }

    public String toString() {
        return "\n  Constraint(" + this.constraintName + ") " + this.conditionFacts + " ";
    }

    public void setConstraintId(String constraintId) {
        this.constraintId = constraintId;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public void setConditionFacts(List<ConditionFact> conditionFacts) {
        this.conditionFacts = conditionFacts;
    }
}

