/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.InvalidComponentIdentifierException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import zz.com.fasterxml.jackson.annotation.JsonIgnore;

public class ComponentIdentifier
implements Comparable<ComponentIdentifier> {
    static final String MUST_HAVE_FORMAT_MESSAGE = "A component identifier must have a format.";
    static final String MUST_HAVE_COORDINATE_MESSAGE = "A component identifier must have at least one coordinate.";
    static final String INCORRECT_COORDINATES = "Coordinates contain the following incorrect entries for the given format: ";
    static final String MISSING_COORDINATES = "The following coordinates are missing for given format: ";
    private static final SortedMap<String, String> UNMODIFIABLE_EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private String format;
    private SortedMap<String, String> coordinates;
    public static final String NPM_PACKAGE_ID = "packageId";
    public static final String NUGET_PACKAGE_ID = "packageId";
    public static final String VERSION = "version";
    public static final String MAVEN_EXTENSION = "extension";
    public static final String MAVEN_CLASSIFIER = "classifier";
    public static final String MAVEN_ARTIFACT_ID = "artifactId";
    public static final String MAVEN_GROUP_ID = "groupId";
    public static final String CONTAINER_NAME = "name";
    public static final String CONTAINER_NAMESPACE = "namespace";
    public static final String IAC_NAME = "name";
    public static final String IAC_NAMESPACE = "namespace";
    public static final String ANAME_NAME = "name";
    public static final String ANAME_QUALIFIER = "qualifier";
    public static final String PYPI_NAME = "name";
    public static final String PYPI_QUALIFIER = "qualifier";
    public static final String PYPI_EXTENSION = "extension";
    public static final String RPM_NAME = "name";
    public static final String RPM_ARCHITECTURE = "architecture";
    public static final String RUBYGEMS_NAME = "name";
    public static final String RUBYGEMS_PLATFORM = "platform";
    static final String RUBYGEMS_PLATFORM_DEFAULT = "ruby";
    public static final String GOLANG_NAME = "name";
    public static final String PECOFF_NAME = "name";
    public static final String PECOFF_NAMESPACE = "namespace";
    public static final String SWIFT_NAME = "name";
    public static final String TERRAFORM_PLAN = "plan";
    public static final String TERRAFORM_NAME = "name";
    public static final String COCOAPODS_NAME = "name";
    public static final String CONAN_NAME = "name";
    public static final String CONAN_OWNER = "owner";
    public static final String CONAN_CHANNEL = "channel";
    public static final String CRAN_NAME = "name";
    public static final String CRAN_TYPE = "type";
    public static final String CARGO_NAME = "name";
    public static final String CARGO_TYPE = "type";
    public static final String CONDA_NAME = "name";
    public static final String CONDA_TYPE = "type";
    public static final String CONDA_CHANNEL = "channel";
    public static final String CONDA_BUILD = "build";
    public static final String CONDA_SUBDIR = "subdir";
    public static final String COMPOSER_NAME = "name";
    public static final String COMPOSER_NAMESPACE = "namespace";
    private static final LinkedHashSet<String> MAVEN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "classifier", "extension"));
    private static final LinkedHashSet<String> MAVEN_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "extension"));
    private static final LinkedHashSet<String> ANAME_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier"));
    private static final LinkedHashSet<String> ANAME_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> NPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> PYPI_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier", "extension"));
    private static final LinkedHashSet<String> PYPI_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> RPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RUBYGEMS_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "platform"));
    private static final LinkedHashSet<String> RUBYGEMS_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> GOLANG_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> GOLANG_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> PECOFF_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "namespace"));
    private static final LinkedHashSet<String> PECOFF_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> SWIFT_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> SWIFT_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> TERRAFORM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("plan", "name", "version"));
    private static final LinkedHashSet<String> TERRAFORM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("plan", "name", "version"));
    private static final LinkedHashSet<String> COCOAPODS_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> COCOAPODS_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> CONTAINER_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    private static final LinkedHashSet<String> CONTAINER_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    private static final LinkedHashSet<String> IAC_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    private static final LinkedHashSet<String> IAC_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    private static final LinkedHashSet<String> CONAN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("owner", "name", "version", "channel"));
    private static final LinkedHashSet<String> CONAN_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> CRAN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "type"));
    private static final LinkedHashSet<String> CRAN_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> CARGO_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "type"));
    private static final LinkedHashSet<String> CARGO_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> CONDA_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("channel", "name", "version", "build", "subdir", "type"));
    private static final LinkedHashSet<String> CONDA_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> COMPOSER_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    private static final LinkedHashSet<String> COMPOSER_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("namespace", "name", "version"));
    public static final String FORMAT_MAVEN = "maven";
    public static final String FORMAT_NPM = "npm";
    public static final String FORMAT_NUGET = "nuget";
    public static final String FORMAT_ANAME = "a-name";
    public static final String FORMAT_PYPI = "pypi";
    public static final String FORMAT_RPM = "rpm";
    public static final String FORMAT_RUBYGEMS = "gem";
    public static final String FORMAT_GOLANG = "golang";
    public static final String FORMAT_PECOFF = "pecoff";
    public static final String FORMAT_SWIFT = "swift";
    public static final String FORMAT_TERRAFORM = "terraform";
    public static final String FORMAT_COCOAPODS = "cocoapods";
    public static final String FORMAT_CONTAINER = "container";
    public static final String FORMAT_IAC = "iac";
    public static final String FORMAT_CONAN = "conan";
    public static final String FORMAT_CRAN = "cran";
    public static final String FORMAT_CARGO = "cargo";
    public static final String FORMAT_CONDA = "conda";
    public static final String FORMAT_COMPOSER = "composer";
    private static final Map<String, Set<String>> FORMAT_TO_COORDINATES = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> FORMAT_TO_REQUIRED_COORDINATES;
    public static final List<String> NO_LICENSE_FORMATS;

    public ComponentIdentifier() {
    }

    public ComponentIdentifier(String format, Map<String, String> coordinates) {
        this.format = format;
        this.setCoordinates(coordinates);
        this.validate();
    }

    public String get(String property) {
        return (String)this.coordinates.get(property);
    }

    public ComponentIdentifier createAlternativeVersion(String version) {
        LinkedHashMap<String, String> coordinates = new LinkedHashMap<String, String>(this.coordinates);
        coordinates.put(VERSION, version);
        return new ComponentIdentifier(this.format, coordinates);
    }

    public static Set<String> getSupportedFormats() {
        return Collections.unmodifiableSet(FORMAT_TO_COORDINATES.keySet());
    }

    public static Set<String> getAllCoordinateNames(String format) {
        if (!FORMAT_TO_COORDINATES.containsKey(format)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_COORDINATES.get(format);
    }

    public static Set<String> getAllRequiredCoordinateNames(String format) {
        if (!FORMAT_TO_REQUIRED_COORDINATES.containsKey(format)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_REQUIRED_COORDINATES.get(format);
    }

    public static ComponentIdentifier createNpmCoordinates(String packageId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("packageId", packageId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_NPM, coords);
    }

    public static ComponentIdentifier createNugetCoordinates(String packageId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("packageId", packageId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_NUGET, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version, String classifier, String extension) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        coords.put(MAVEN_CLASSIFIER, classifier);
        coords.put("extension", extension);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public static ComponentIdentifier createContainerCoordinates(String namespace, String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("namespace", namespace);
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_CONTAINER, coords);
    }

    public static ComponentIdentifier createIacCoordinates(String namespace, String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("namespace", namespace);
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_IAC, coords);
    }

    public static ComponentIdentifier createAnameCoordinates(String name, String qualifier, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put("qualifier", qualifier);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_ANAME, coords);
    }

    public static ComponentIdentifier createPypiCoordinates(String name, String version, String qualifier, String extension) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put("qualifier", qualifier);
        coords.put("extension", extension);
        return new ComponentIdentifier(FORMAT_PYPI, coords);
    }

    public static ComponentIdentifier createRpmCoordinates(String name, String version, String architecture) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put(RPM_ARCHITECTURE, architecture);
        return new ComponentIdentifier(FORMAT_RPM, coords);
    }

    public static ComponentIdentifier createRubyGemsCoordinates(String name, String version, String platform) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put(RUBYGEMS_PLATFORM, platform);
        return new ComponentIdentifier(FORMAT_RUBYGEMS, coords);
    }

    public static ComponentIdentifier createGolangCoordinates(String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_GOLANG, coords);
    }

    public static ComponentIdentifier createPecoffCoordinates(String namespace, String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put("namespace", namespace);
        return new ComponentIdentifier(FORMAT_PECOFF, coords);
    }

    public static ComponentIdentifier createSwiftCoordinates(String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_SWIFT, coords);
    }

    public static ComponentIdentifier createTerraformCoordinates(String plan, String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(TERRAFORM_PLAN, plan);
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_TERRAFORM, coords);
    }

    public static ComponentIdentifier createCocoapodsCoordinates(String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_COCOAPODS, coords);
    }

    public static ComponentIdentifier createConanCoordinates(String name, String version, String owner, String channel) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        if (owner != null && !owner.trim().equals("")) {
            coords.put(CONAN_OWNER, owner);
        }
        if (channel != null && !channel.trim().equals("")) {
            coords.put("channel", channel);
        }
        return new ComponentIdentifier(FORMAT_CONAN, coords);
    }

    public static ComponentIdentifier createCranCoordinates(String name, String version, String type) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        if (type != null && !type.trim().equals("")) {
            coords.put("type", type);
        }
        return new ComponentIdentifier(FORMAT_CRAN, coords);
    }

    public static ComponentIdentifier createCargoCoordinates(String name, String version, String type) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        if (type != null && !type.trim().equals("")) {
            coords.put("type", type);
        }
        return new ComponentIdentifier(FORMAT_CARGO, coords);
    }

    public static ComponentIdentifier createCondaCoordinates(String name, String version, String channel, String build, String subdir, String type) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        if (ComponentIdentifier.isNotBlank(channel)) {
            coords.put("channel", channel);
        }
        if (ComponentIdentifier.isNotBlank(build)) {
            coords.put(CONDA_BUILD, build);
        }
        if (ComponentIdentifier.isNotBlank(subdir)) {
            coords.put(CONDA_SUBDIR, subdir);
        }
        if (ComponentIdentifier.isNotBlank(type)) {
            coords.put("type", type);
        }
        return new ComponentIdentifier(FORMAT_CONDA, coords);
    }

    public static ComponentIdentifier createCondaCoordinates(String name, String version) {
        return ComponentIdentifier.createCondaCoordinates(name, version, null, null, null, null);
    }

    public static ComponentIdentifier createComposerCoordinates(String namespace, String name, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("namespace", namespace);
        coords.put("name", name);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_COMPOSER, coords);
    }

    private static boolean isNotBlank(String coordinate) {
        return coordinate != null && !coordinate.trim().equals("");
    }

    public void ensureComplete() throws InvalidComponentIdentifierException {
        this.ensureRequired();
        if (this.isMaven()) {
            if (!this.coordinates.containsKey(MAVEN_CLASSIFIER)) {
                this.coordinates.put(MAVEN_CLASSIFIER, "");
            }
        } else if (FORMAT_ANAME.equals(this.format)) {
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
        } else if (FORMAT_PYPI.equals(this.format)) {
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
            if (!this.coordinates.containsKey("extension")) {
                this.coordinates.put("extension", "");
            }
        } else if (FORMAT_RUBYGEMS.equals(this.format)) {
            if (!this.coordinates.containsKey(RUBYGEMS_PLATFORM) || "".equals(this.coordinates.get(RUBYGEMS_PLATFORM))) {
                this.coordinates.put(RUBYGEMS_PLATFORM, RUBYGEMS_PLATFORM_DEFAULT);
            }
        } else if (FORMAT_PECOFF.equals(this.format)) {
            if (!this.coordinates.containsKey("namespace")) {
                this.coordinates.put("namespace", "");
            }
        } else if (FORMAT_CONAN.equals(this.format)) {
            if (!this.coordinates.containsKey("channel")) {
                this.coordinates.put("channel", "");
            }
            if (!this.coordinates.containsKey(CONAN_OWNER)) {
                this.coordinates.put(CONAN_OWNER, "");
            }
        }
    }

    public void ensureRequired() throws InvalidComponentIdentifierException {
        if (this.isMaven()) {
            this.validateRequiredCoordinates(MAVEN_REQUIRED_COORDINATES);
        } else if (FORMAT_NPM.equals(this.format)) {
            this.validateRequiredCoordinates(NPM_REQUIRED_COORDINATES);
        } else if (FORMAT_NUGET.equals(this.format)) {
            this.validateRequiredCoordinates(NUGET_REQUIRED_COORDINATES);
        } else if (FORMAT_ANAME.equals(this.format)) {
            this.validateRequiredCoordinates(ANAME_REQUIRED_COORDINATES);
        } else if (FORMAT_PYPI.equals(this.format)) {
            this.validateRequiredCoordinates(PYPI_REQUIRED_COORDINATES);
        } else if (FORMAT_RPM.equals(this.format)) {
            this.validateRequiredCoordinates(RPM_REQUIRED_COORDINATES);
        } else if (FORMAT_RUBYGEMS.equals(this.format)) {
            this.validateRequiredCoordinates(RUBYGEMS_REQUIRED_COORDINATES);
        } else if (FORMAT_GOLANG.equals(this.format)) {
            this.validateRequiredCoordinates(GOLANG_REQUIRED_COORDINATES);
        } else if (FORMAT_PECOFF.equals(this.format)) {
            this.validateRequiredCoordinates(PECOFF_REQUIRED_COORDINATES);
        } else if (FORMAT_SWIFT.equals(this.format)) {
            this.validateRequiredCoordinates(SWIFT_REQUIRED_COORDINATES);
        } else if (FORMAT_TERRAFORM.equals(this.format)) {
            this.validateRequiredCoordinates(TERRAFORM_REQUIRED_COORDINATES);
        } else if (FORMAT_COCOAPODS.equals(this.format)) {
            this.validateRequiredCoordinates(COCOAPODS_REQUIRED_COORDINATES);
        } else if (FORMAT_CONTAINER.equals(this.format)) {
            this.validateRequiredCoordinates(CONTAINER_REQUIRED_COORDINATES);
        } else if (FORMAT_IAC.equals(this.format)) {
            this.validateRequiredCoordinates(IAC_REQUIRED_COORDINATES);
        } else if (FORMAT_CONAN.equals(this.format)) {
            this.validateRequiredCoordinates(CONAN_REQUIRED_COORDINATES);
        } else if (FORMAT_CRAN.equals(this.format)) {
            this.validateRequiredCoordinates(CRAN_REQUIRED_COORDINATES);
        } else if (FORMAT_CARGO.equals(this.format)) {
            this.validateRequiredCoordinates(CARGO_REQUIRED_COORDINATES);
        } else if (FORMAT_CONDA.equals(this.format)) {
            this.validateRequiredCoordinates(CONDA_REQUIRED_COORDINATES);
        } else if (FORMAT_COMPOSER.equals(this.format)) {
            this.validateRequiredCoordinates(COMPOSER_REQUIRED_COORDINATES);
        }
    }

    private void validateRequiredCoordinates(Set<String> requiredKeys) throws InvalidComponentIdentifierException {
        if (!this.coordinates.keySet().containsAll(requiredKeys)) {
            TreeSet<String> keyCopy = new TreeSet<String>(requiredKeys);
            keyCopy.removeAll(this.coordinates.keySet());
            throw new InvalidComponentIdentifierException(MISSING_COORDINATES + keyCopy);
        }
    }

    public String toString() {
        return this.format + ": " + this.coordinates;
    }

    public int hashCode() {
        return Objects.hash(this.format, this.coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentIdentifier)) {
            return false;
        }
        ComponentIdentifier other = (ComponentIdentifier)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.coordinates, other.coordinates);
    }

    @Override
    public int compareTo(ComponentIdentifier that) {
        int rel = this.format.compareTo(that.format);
        if (rel != 0) {
            return rel;
        }
        if (this.isMaven()) {
            return this.compareCoordinates(that, MAVEN_COORDINATE_NAMES);
        }
        if (FORMAT_NPM.equals(this.format)) {
            return this.compareCoordinates(that, NPM_COORDINATE_NAMES);
        }
        if (FORMAT_NUGET.equals(this.format)) {
            return this.compareCoordinates(that, NUGET_COORDINATE_NAMES);
        }
        if (FORMAT_ANAME.equals(this.format)) {
            return this.compareCoordinates(that, ANAME_COORDINATE_NAMES);
        }
        if (FORMAT_PYPI.equals(this.format)) {
            return this.compareCoordinates(that, PYPI_COORDINATE_NAMES);
        }
        if (FORMAT_RPM.equals(this.format)) {
            return this.compareCoordinates(that, RPM_COORDINATE_NAMES);
        }
        if (FORMAT_RUBYGEMS.equals(this.format)) {
            return this.compareCoordinates(that, RUBYGEMS_COORDINATE_NAMES);
        }
        if (FORMAT_GOLANG.equals(this.format)) {
            return this.compareCoordinates(that, GOLANG_COORDINATE_NAMES);
        }
        if (FORMAT_PECOFF.equals(this.format)) {
            return this.compareCoordinates(that, PECOFF_COORDINATE_NAMES);
        }
        if (FORMAT_SWIFT.equals(this.format)) {
            return this.compareCoordinates(that, SWIFT_COORDINATE_NAMES);
        }
        if (FORMAT_TERRAFORM.equals(this.format)) {
            return this.compareCoordinates(that, TERRAFORM_COORDINATE_NAMES);
        }
        if (FORMAT_COCOAPODS.equals(this.format)) {
            return this.compareCoordinates(that, COCOAPODS_COORDINATE_NAMES);
        }
        if (FORMAT_CONTAINER.equals(this.format)) {
            return this.compareCoordinates(that, CONTAINER_COORDINATE_NAMES);
        }
        if (FORMAT_IAC.equals(this.format)) {
            return this.compareCoordinates(that, IAC_COORDINATE_NAMES);
        }
        if (FORMAT_CONAN.equals(this.format)) {
            return this.compareCoordinates(that, CONAN_COORDINATE_NAMES);
        }
        if (FORMAT_CRAN.equals(this.format)) {
            return this.compareCoordinates(that, CRAN_COORDINATE_NAMES);
        }
        if (FORMAT_CARGO.equals(this.format)) {
            return this.compareCoordinates(that, CARGO_COORDINATE_NAMES);
        }
        if (FORMAT_CONDA.equals(this.format)) {
            return this.compareCoordinates(that, CONDA_COORDINATE_NAMES);
        }
        if (FORMAT_COMPOSER.equals(this.format)) {
            return this.compareCoordinates(that, COMPOSER_COORDINATE_NAMES);
        }
        return ComponentIdentifier.join(this.coordinates).compareTo(ComponentIdentifier.join(that.coordinates));
    }

    private int compareCoordinates(ComponentIdentifier that, LinkedHashSet<String> coordinateNames) {
        for (String coordinateName : coordinateNames) {
            int rel = ComponentIdentifier.compareNullableStrings(this.get(coordinateName), that.get(coordinateName));
            if (rel == 0) continue;
            return rel;
        }
        return 0;
    }

    private static String join(Map<String, String> coordinates) {
        if (coordinates == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (String value : coordinates.values()) {
            result.append(value);
        }
        return result.toString();
    }

    private static int compareNullableStrings(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public String getFormat() {
        return this.format;
    }

    public SortedMap<String, String> getCoordinates() {
        if (this.coordinates == null) {
            return UNMODIFIABLE_EMPTY_SORTED_MAP;
        }
        return Collections.unmodifiableSortedMap(this.coordinates);
    }

    public void validate() throws InvalidComponentIdentifierException {
        if (this.format == null || this.format.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_FORMAT_MESSAGE);
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_COORDINATE_MESSAGE);
        }
        if (this.format.equals(FORMAT_MAVEN)) {
            this.validateNoUnexpectedCoordinates(MAVEN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NPM)) {
            this.validateNoUnexpectedCoordinates(NPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NUGET)) {
            this.validateNoUnexpectedCoordinates(NUGET_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_ANAME)) {
            this.validateNoUnexpectedCoordinates(ANAME_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_PYPI)) {
            this.validateNoUnexpectedCoordinates(PYPI_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RPM)) {
            this.validateNoUnexpectedCoordinates(RPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RUBYGEMS)) {
            this.validateNoUnexpectedCoordinates(RUBYGEMS_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_GOLANG)) {
            this.validateNoUnexpectedCoordinates(GOLANG_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_PECOFF)) {
            this.validateNoUnexpectedCoordinates(PECOFF_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_SWIFT)) {
            this.validateNoUnexpectedCoordinates(SWIFT_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_TERRAFORM)) {
            this.validateNoUnexpectedCoordinates(TERRAFORM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_COCOAPODS)) {
            this.validateNoUnexpectedCoordinates(COCOAPODS_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_CONAN)) {
            this.validateNoUnexpectedCoordinates(CONAN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_CARGO)) {
            this.validateNoUnexpectedCoordinates(CARGO_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_CRAN)) {
            this.validateNoUnexpectedCoordinates(CRAN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_CONDA)) {
            this.validateNoUnexpectedCoordinates(CONDA_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_COMPOSER)) {
            this.validateNoUnexpectedCoordinates(COMPOSER_COORDINATE_NAMES);
        }
    }

    private void validateNoUnexpectedCoordinates(Set<String> expectedKeys) {
        if (!expectedKeys.containsAll(this.coordinates.keySet())) {
            TreeSet<String> keyCopy = new TreeSet<String>(this.coordinates.keySet());
            keyCopy.removeAll(expectedKeys);
            throw new InvalidComponentIdentifierException(INCORRECT_COORDINATES + keyCopy);
        }
    }

    private void setCoordinates(Map<String, String> coordinates) {
        if (coordinates == null) {
            return;
        }
        this.coordinates = new TreeMap<String, String>();
        for (Map.Entry<String, String> coordinate : coordinates.entrySet()) {
            if (coordinate.getValue() == null) continue;
            this.coordinates.put(coordinate.getKey(), coordinate.getValue());
        }
    }

    @JsonIgnore
    public boolean isMaven() {
        return FORMAT_MAVEN.equals(this.format);
    }

    @JsonIgnore
    public boolean isAname() {
        return FORMAT_ANAME.equals(this.format);
    }

    @JsonIgnore
    public boolean isTerraform() {
        return FORMAT_TERRAFORM.equals(this.format);
    }

    @JsonIgnore
    public boolean isContainer() {
        return FORMAT_CONTAINER.equals(this.format);
    }

    @JsonIgnore
    public boolean isIac() {
        return FORMAT_IAC.equals(this.format);
    }

    @JsonIgnore
    public boolean isCaseSensitive() {
        return ComponentIdentifier.isCaseSensitive(this.format);
    }

    public static boolean isCaseSensitive(String format) {
        switch (format) {
            case "nuget": 
            case "pypi": {
                return false;
            }
        }
        return true;
    }

    @JsonIgnore
    public Set<String> getProprietaryCoordinates() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        switch (this.format) {
            case "maven": {
                result.add(this.get(MAVEN_GROUP_ID));
                result.add(this.get(MAVEN_ARTIFACT_ID));
                break;
            }
            case "npm": {
                result.add(this.get("packageId"));
                break;
            }
            case "nuget": {
                result.add(this.get("packageId"));
                break;
            }
            case "a-name": {
                result.add(this.get("name"));
                break;
            }
            case "pypi": {
                result.add(this.get("name"));
                break;
            }
            case "rpm": {
                result.add(this.get("name"));
                break;
            }
            case "gem": {
                result.add(this.get("name"));
                break;
            }
            case "golang": {
                result.add(this.get("name"));
                break;
            }
            case "pecoff": {
                result.add(this.get("name"));
                break;
            }
            case "swift": {
                result.add(this.get("name"));
                break;
            }
            case "terraform": {
                result.add(this.get("name"));
                break;
            }
            case "cocoapods": {
                result.add(this.get("name"));
                break;
            }
            case "container": {
                result.add(this.get("name"));
                break;
            }
            case "iac": {
                result.add(this.get("name"));
                break;
            }
            case "conan": {
                result.add(this.get("name"));
                break;
            }
            case "cran": {
                result.add(this.get("name"));
                break;
            }
            case "cargo": {
                result.add(this.get("name"));
                break;
            }
            case "conda": {
                result.add(this.get("name"));
                break;
            }
            case "composer": {
                result.add(this.get("namespace"));
                result.add(this.get("name"));
                break;
            }
            default: {
                String name = this.get("name");
                if (name == null) break;
                result.add(name);
                break;
            }
        }
        return result;
    }

    static {
        FORMAT_TO_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_GOLANG, Collections.unmodifiableSet(GOLANG_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_PECOFF, Collections.unmodifiableSet(PECOFF_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_SWIFT, Collections.unmodifiableSet(SWIFT_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_TERRAFORM, Collections.unmodifiableSet(TERRAFORM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_COCOAPODS, Collections.unmodifiableSet(COCOAPODS_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_CONAN, Collections.unmodifiableSet(CONAN_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_CRAN, Collections.unmodifiableSet(CRAN_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_CARGO, Collections.unmodifiableSet(CARGO_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_CONDA, Collections.unmodifiableSet(CONDA_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_COMPOSER, Collections.unmodifiableSet(COMPOSER_COORDINATE_NAMES));
        FORMAT_TO_REQUIRED_COORDINATES = new HashMap<String, Set<String>>();
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_GOLANG, Collections.unmodifiableSet(GOLANG_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_PECOFF, Collections.unmodifiableSet(PECOFF_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_SWIFT, Collections.unmodifiableSet(SWIFT_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_TERRAFORM, Collections.unmodifiableSet(TERRAFORM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_COCOAPODS, Collections.unmodifiableSet(COCOAPODS_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_CONTAINER, Collections.unmodifiableSet(CONTAINER_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_IAC, Collections.unmodifiableSet(IAC_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_CONAN, Collections.unmodifiableSet(CONAN_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_CRAN, Collections.unmodifiableSet(CRAN_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_CARGO, Collections.unmodifiableSet(CARGO_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_CONDA, Collections.unmodifiableSet(CONDA_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_COMPOSER, Collections.unmodifiableSet(COMPOSER_REQUIRED_COORDINATES));
        NO_LICENSE_FORMATS = Collections.unmodifiableList(Arrays.asList(FORMAT_SWIFT, FORMAT_COCOAPODS, FORMAT_CARGO, FORMAT_CRAN, FORMAT_CONDA));
    }
}

