/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.upgrades;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.browse.RebuildBrowseNodesManager;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class BrowseNodeMigrationStep_1_1
implements DatabaseMigrationStep {
    private static final String TRUNCATE = "DELETE FROM {format}_browse_node";
    private static final String TABLE_NAME = "{format}_browse_node";
    private final RebuildBrowseNodesManager rebuildBrowseNodesManager;
    private List<String> formats;

    @Inject
    public BrowseNodeMigrationStep_1_1(List<Format> formats, RebuildBrowseNodesManager rebuildBrowseNodesManager) {
        this.formats = formats.stream().map(Format::getValue).collect(Collectors.toList());
        this.rebuildBrowseNodesManager = (RebuildBrowseNodesManager)((Object)Preconditions.checkNotNull((Object)((Object)rebuildBrowseNodesManager)));
    }

    public Optional<String> version() {
        return Optional.of("1.1");
    }

    public void migrate(Connection connection) throws Exception {
        for (String format : this.formats) {
            this.migrate(format, connection);
        }
        this.rebuildBrowseNodesManager.setRebuildOnSart(true);
    }

    private void migrate(String formatName, Connection conn) throws SQLException {
        if (!this.tableExists(conn, BrowseNodeMigrationStep_1_1.format(TABLE_NAME, formatName))) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement select = conn.prepareStatement(BrowseNodeMigrationStep_1_1.format(TRUNCATE, formatName));){
            select.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String format(String query, String format) {
        return query.replaceAll("\\{format\\}", format);
    }
}

