/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.event.component.ComponentAttributesEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentKindEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentUpdatedEvent;

@Named
@Singleton
public class ComponentAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository.component";

    public ComponentAuditor() {
        this.registerType(ComponentCreatedEvent.class, "created");
        this.registerType(ComponentDeletedEvent.class, "deleted");
        this.registerType(ComponentPurgedEvent.class, "purged");
        this.registerType(ComponentUpdatedEvent.class, "updated");
        this.registerType(ComponentKindEvent.class, "updated-kind");
        this.registerType(ComponentAttributesEvent.class, "updated-attribute");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentPurgedEvent event) {
        if (this.isRecording()) {
            String repositoryName = event.getRepository().map(Repository::getName).orElse("Unknown");
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(repositoryName);
            Map attributes = data.getAttributes();
            attributes.put("repository.name", repositoryName);
            attributes.put("componentIds", Arrays.toString(event.getComponentIds()));
            this.record(data);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentEvent event) {
        if (this.isRecording()) {
            Component component = event.getComponent();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(component.name());
            Map attributes = data.getAttributes();
            attributes.put("repository.name", event.getRepository().map(Repository::getName).orElse("Unknown"));
            attributes.put("name", component.name());
            attributes.put("kind", component.kind());
            attributes.put("namespace", component.namespace());
            attributes.put("version", component.version());
            if (event instanceof ComponentAttributesEvent) {
                ComponentAttributesEvent attributesEvent = (ComponentAttributesEvent)event;
                attributes.put("attribute.change", attributesEvent.getChange());
                attributes.put("attribute.key", attributesEvent.getKey());
                attributes.put("attribute.value", attributesEvent.getValue());
            }
            this.record(data);
        }
    }
}

