/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class AssetBlobCleanupTask
extends TaskSupport
implements Cancelable {
    static final String PROPERTY_PREFIX = "nexus.assetBlobCleanupTask.";
    static final String CRON_SCHEDULE = SystemPropertiesHelper.getString((String)"nexus.assetBlobCleanupTask.cronSchedule", (String)"0 */30 * * * ?");
    static final int BATCH_SIZE = SystemPropertiesHelper.getInteger((String)"nexus.assetBlobCleanupTask.batchSize", (int)100);
    static final boolean HARD_DELETE = SystemPropertiesHelper.getBoolean((String)"nexus.assetBlobCleanupTask.hardDelete", (boolean)false);
    private final Map<String, FormatStoreManager> formatStoreManagers;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public AssetBlobCleanupTask(Map<String, FormatStoreManager> formatStoreManagers, BlobStoreManager blobStoreManager) {
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    protected Void execute() throws Exception {
        String format = this.getConfiguration().getString("format");
        String contentStore = this.getConfiguration().getString("contentStore");
        FormatStoreManager formatStoreManager = this.formatStoreManagers.get(format);
        if (formatStoreManager != null) {
            this.log.debug("Checking for unused {} blobs from {}", (Object)format, (Object)contentStore);
            Object assetBlobStore = formatStoreManager.assetBlobStore(contentStore);
            int deleteCount = this.deleteUnusedAssetBlobs((AssetBlobStore<?>)((Object)assetBlobStore), format, contentStore);
            if (deleteCount > 0) {
                this.log.info("Deleted {} unused {} blobs from {}", new Object[]{deleteCount, format, contentStore});
            }
        } else {
            this.log.warn("Unknown format {}", (Object)format);
        }
        return null;
    }

    private int deleteUnusedAssetBlobs(AssetBlobStore<?> assetBlobStore, String format, String contentStore) {
        int deleteCount = 0;
        Continuation<AssetBlob> unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, null);
        while (!this.isCanceled() && !unusedAssetBlobs.isEmpty()) {
            this.log.debug("Found {} unused {} blobs in {}", new Object[]{unusedAssetBlobs.size(), format, contentStore});
            for (AssetBlob assetBlob : unusedAssetBlobs) {
                if (this.isCanceled()) break;
                try {
                    if (this.deleteAssetBlob(assetBlobStore, assetBlob.blobRef())) {
                        ++deleteCount;
                        continue;
                    }
                    this.log.debug("Could not delete {} blob {} from {}", new Object[]{format, assetBlob.blobRef(), contentStore});
                }
                catch (RuntimeException e) {
                    this.log.debug("Could not delete {} blob {} from {}", new Object[]{format, assetBlob.blobRef(), contentStore, e});
                }
            }
            unusedAssetBlobs = assetBlobStore.browseUnusedAssetBlobs(BATCH_SIZE, unusedAssetBlobs.nextContinuationToken());
        }
        return deleteCount;
    }

    private boolean deleteAssetBlob(AssetBlobStore<?> assetBlobStore, BlobRef blobRef) {
        boolean assetBlobDeleted = false;
        BlobStore blobStore = this.blobStoreManager.get(blobRef.getStore());
        if (blobStore == null) {
            this.log.warn("Could not find blob store for {}", (Object)blobRef);
        } else {
            assetBlobDeleted = assetBlobStore.deleteAssetBlob(blobRef);
            if (assetBlobDeleted && !this.deleteBlobContent(blobStore, blobRef)) {
                this.log.warn("Could not delete blob content under {}", (Object)blobRef);
            }
        }
        return assetBlobDeleted;
    }

    private boolean deleteBlobContent(BlobStore blobStore, BlobRef blobRef) {
        if (HARD_DELETE) {
            return blobStore.deleteHard(blobRef.getBlobId());
        }
        return blobStore.delete(blobRef.getBlobId(), "Removing unused asset blob");
    }

    public String getMessage() {
        return this.getName();
    }
}

