/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.OptionalInt;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.ContentRepository;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.store.AbstractRepositoryContent;
import org.sonatype.nexus.repository.content.store.AssetBlobData;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.content.store.WrappedContent;

public class InternalIds {
    private static final long TO_EXTERNAL = 1327217885L;
    private static final long TO_INTERNAL = 828308341L;

    private InternalIds() {
    }

    public static EntityId toExternalId(int internalId) {
        Preconditions.checkArgument((internalId > 0 ? 1 : 0) != 0);
        return EntityHelper.id((String)Integer.toHexString((int)((long)internalId * 1327217885L)));
    }

    public static int toInternalId(EntityId externalId) {
        return (int)((long)Integer.parseUnsignedInt(externalId.getValue(), 16) * 828308341L);
    }

    public static Optional<Integer> contentRepositoryId(Repository repository) {
        return repository.optionalFacet(ContentFacet.class).map(ContentRepository::contentRepositoryId);
    }

    public static int contentRepositoryId(RepositoryContent content) {
        return InternalIds.checkInternalId(((AbstractRepositoryContent)InternalIds.unwrap((RepositoryContent)content)).repositoryId);
    }

    public static int contentRepositoryId(ContentStoreEvent event) {
        return event.contentRepositoryId;
    }

    public static int internalComponentId(Component component) {
        return InternalIds.checkInternalId(((ComponentData)InternalIds.unwrap((RepositoryContent)component)).componentId);
    }

    public static int internalAssetBlobId(AssetBlob assetBlob) {
        return InternalIds.checkInternalId(((AssetBlobData)assetBlob).assetBlobId);
    }

    public static int internalAssetId(Asset asset) {
        return InternalIds.checkInternalId(((AssetData)InternalIds.unwrap((RepositoryContent)asset)).assetId);
    }

    public static OptionalInt internalComponentId(Asset asset) {
        AssetData assetData = (AssetData)InternalIds.unwrap(asset);
        return Optional.ofNullable(assetData.componentId).map(OptionalInt::of).orElseGet(() -> assetData.component().map(InternalIds::internalComponentId).map(OptionalInt::of).orElse(OptionalInt.empty()));
    }

    public static OptionalInt internalAssetBlobId(Asset asset) {
        return Optional.ofNullable(((AssetData)InternalIds.unwrap((RepositoryContent)asset)).assetBlobId).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    private static int checkInternalId(Integer internalId) {
        Preconditions.checkState((internalId != null ? 1 : 0) != 0, (Object)"Entity does not have an internal id; is it detached?");
        return internalId;
    }

    private static RepositoryContent unwrap(RepositoryContent content) {
        return content instanceof WrappedContent ? ((WrappedContent)((Object)content)).unwrap() : content;
    }
}

