/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.content.store.ContentStoreFactory;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.repository.content.store.FormatStoreFactory;

public abstract class ContentStoreModule<STORE extends ContentStoreSupport<?>>
extends AbstractModule {
    final Named format = ((Object)((Object)this)).getClass().getAnnotation(Named.class);
    final String formatClassPrefix;
    private final Type[] formatStoreTypes;

    protected ContentStoreModule() {
        this(ContentStoreModule.class);
    }

    protected ContentStoreModule(Class<? extends ContentStoreModule> templateModule) {
        Preconditions.checkArgument((this.format != null && this.format.value().length() > 0 ? 1 : 0) != 0, (String)"%s must be annotated with @Named(\"myformat\")", ((Object)((Object)this)).getClass());
        this.formatClassPrefix = ((Object)((Object)this)).getClass().getSimpleName().substring(0, this.format.value().length());
        Preconditions.checkArgument((boolean)this.formatClassPrefix.equalsIgnoreCase(this.format.value()), (String)"%s must start with %s", ((Object)((Object)this)).getClass(), (Object)Strings2.capitalize((String)this.format.value()));
        this.formatStoreTypes = ContentStoreModule.typeArguments(((Object)((Object)this)).getClass(), templateModule);
    }

    protected void configure() {
        Type[] typeArray = this.formatStoreTypes;
        int n = this.formatStoreTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type formatStoreType = typeArray[n2];
            this.bindFormatStoreFactory(formatStoreType);
            ++n2;
        }
    }

    private void bindFormatStoreFactory(Type formatStoreType) {
        Class formatDaoClass = (Class)ContentStoreModule.typeArguments(formatStoreType, ContentStoreSupport.class)[0];
        Preconditions.checkArgument((boolean)formatDaoClass.getSimpleName().startsWith(this.formatClassPrefix), (String)"%s must start with %s", (Object)formatDaoClass, (Object)this.formatClassPrefix);
        ParameterizedType factoryType = Types.newParameterizedType(ContentStoreFactory.class, (Type[])new Type[]{formatStoreType, formatDaoClass});
        Key factoryKey = Key.get((Type)factoryType, (Annotation)this.format);
        this.install(new FactoryModuleBuilder().build(factoryKey));
        FormatStoreFactory formatStoreFactory = new FormatStoreFactory((Provider<ContentStoreFactory>)this.getProvider(factoryKey), formatDaoClass);
        this.bind(FormatStoreFactory.class).annotatedWith((Annotation)Names.named((String)formatDaoClass.getSimpleName())).toInstance((Object)formatStoreFactory);
    }

    private static Type[] typeArguments(Type type, Class<?> supertype) {
        TypeLiteral superType = TypeLiteral.get((Type)type).getSupertype(supertype);
        return ((ParameterizedType)superType.getType()).getActualTypeArguments();
    }
}

