/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.inject.assistedinject.Assisted;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.AttributesHelper;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.event.component.ComponentAttributesEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentKindEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPreDeleteEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPrePurgeEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.store.ComponentDAO;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ContentStoreEventSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class ComponentStore<T extends ComponentDAO>
extends ContentStoreEventSupport<T> {
    @Inject
    public ComponentStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public int countComponents(int repositoryId, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((ComponentDAO)this.dao()).countComponents(repositoryId, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<Component> browseComponents(int repositoryId, int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((ComponentDAO)this.dao()).browseComponents(repositoryId, limit, continuationToken, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<Component> browseComponents(Set<Integer> repositoryIds, int limit, @Nullable String continuationToken) {
        return ((ComponentDAO)this.dao()).browseComponentsInRepositories(repositoryIds, limit, continuationToken);
    }

    @Transactional
    public Collection<String> browseNamespaces(int repositoryId) {
        return ((ComponentDAO)this.dao()).browseNamespaces(repositoryId);
    }

    @Transactional
    public Collection<String> browseNames(int repositoryId, String namespace) {
        return ((ComponentDAO)this.dao()).browseNames(repositoryId, namespace);
    }

    @Transactional
    public Collection<String> browseVersions(int repositoryId, String namespace, String name) {
        return ((ComponentDAO)this.dao()).browseVersions(repositoryId, namespace, name);
    }

    @Transactional
    public void createComponent(ComponentData component) {
        ((ComponentDAO)this.dao()).createComponent(component);
        this.postCommitEvent(() -> new ComponentCreatedEvent(component));
    }

    @Transactional
    public Optional<Component> readComponent(int componentId) {
        return ((ComponentDAO)this.dao()).readComponent(componentId);
    }

    @Transactional
    public Optional<Component> readCoordinate(int repositoryId, String namespace, String name, String version) {
        return ((ComponentDAO)this.dao()).readCoordinate(repositoryId, namespace, name, version);
    }

    @Transactional
    public void updateComponentKind(Component component) {
        ((ComponentDAO)this.dao()).updateComponentKind(component);
        this.postCommitEvent(() -> new ComponentKindEvent(component));
    }

    @Transactional
    public void updateComponentAttributes(Component component, AttributeOperation change, String key, @Nullable Object value) {
        ((ComponentDAO)this.dao()).readComponentAttributes(component).ifPresent(attributes -> {
            ((ComponentData)component).setAttributes((NestedAttributesMap)attributes);
            if (AttributesHelper.applyAttributeChange((AttributesMap)attributes, change, key, value)) {
                ((ComponentDAO)this.dao()).updateComponentAttributes(component);
                this.postCommitEvent(() -> new ComponentAttributesEvent(component, change, key, value));
            }
        });
    }

    @Transactional
    public boolean deleteComponent(Component component) {
        this.preCommitEvent(() -> new ComponentPreDeleteEvent(component));
        boolean deleted = ((ComponentDAO)this.dao()).deleteComponent(component);
        if (deleted) {
            this.postCommitEvent(() -> new ComponentDeletedEvent(component));
        }
        return deleted;
    }

    @Transactional
    public boolean deleteCoordinate(int repositoryId, String namespace, String name, String version) {
        return ((ComponentDAO)this.dao()).readCoordinate(repositoryId, namespace, name, version).map(this::deleteComponent).orElse(false);
    }

    @Transactional
    public boolean deleteComponents(int repositoryId) {
        this.log.debug("Deleting all components in repository {}", (Object)repositoryId);
        boolean deleted = false;
        while (((ComponentDAO)this.dao()).deleteComponents(repositoryId, this.deleteBatchSize())) {
            this.commitChangesSoFar();
            deleted = true;
        }
        this.log.debug("Deleted all components in repository {}", (Object)repositoryId);
        return deleted;
    }

    @Transactional
    public int purgeNotRecentlyDownloaded(int repositoryId, int daysAgo) {
        int[] componentIds;
        int purged = 0;
        while ((componentIds = ((ComponentDAO)this.dao()).selectNotRecentlyDownloaded(repositoryId, daysAgo, this.deleteBatchSize())).length != 0) {
            purged += this.purge(repositoryId, componentIds);
            this.commitChangesSoFar();
        }
        return purged;
    }

    @Transactional
    public int purge(int repositoryId, int[] componentIds) {
        int purged = 0;
        if (componentIds.length == 0) {
            return purged;
        }
        purged = "H2".equals(this.thisSession().sqlDialect()) ? (purged += ((ComponentDAO)this.dao()).purgeSelectedComponents((Integer[])Arrays.stream(componentIds).boxed().toArray(Integer[]::new))) : (purged += ((ComponentDAO)this.dao()).purgeSelectedComponents(componentIds));
        this.preCommitEvent(() -> new ComponentPrePurgeEvent(repositoryId, componentIds));
        this.postCommitEvent(() -> new ComponentPurgedEvent(repositoryId, componentIds));
        return purged;
    }
}

