/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.datastore.api.Expects;
import org.sonatype.nexus.datastore.api.SchemaTemplate;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ContentRepositoryDAO;

@Expects(value={ContentRepositoryDAO.class})
@SchemaTemplate(value="format")
public interface ComponentDAO
extends ContentDataAccess {
    public static final String FILTER_PARAMS = "filterParams";

    public int countComponents(@Param(value="repositoryId") int var1, @Nullable @Param(value="kind") String var2, @Nullable @Param(value="filter") String var3, @Nullable @Param(value="filterParams") Map<String, Object> var4);

    public Continuation<Component> browseComponents(@Param(value="repositoryId") int var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3, @Nullable @Param(value="kind") String var4, @Nullable @Param(value="filter") String var5, @Nullable @Param(value="filterParams") Map<String, Object> var6);

    public Continuation<Component> browseComponentsInRepositories(@Param(value="repositoryIds") Set<Integer> var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3);

    public Collection<String> browseNamespaces(@Param(value="repositoryId") int var1);

    public Collection<String> browseNames(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2);

    public Collection<String> browseVersions(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2, @Param(value="name") String var3);

    public void createComponent(ComponentData var1);

    public Optional<Component> readComponent(@Param(value="componentId") int var1);

    public Optional<Component> readCoordinate(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2, @Param(value="name") String var3, @Param(value="version") String var4);

    public void updateComponentKind(Component var1);

    public Optional<NestedAttributesMap> readComponentAttributes(Component var1);

    public void updateComponentAttributes(Component var1);

    public boolean deleteComponent(Component var1);

    public boolean deleteComponents(@Param(value="repositoryId") int var1, @Param(value="limit") int var2);

    public int[] selectNotRecentlyDownloaded(@Param(value="repositoryId") int var1, @Param(value="daysAgo") int var2, @Param(value="limit") int var3);

    public int purgeSelectedComponents(@Param(value="componentIds") int[] var1);

    public int purgeSelectedComponents(@Param(value="componentIds") Integer[] var1);
}

