/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.datastore.mybatis.handlers.ContentTypeHandler;

@Named
@Singleton
public class BlobRefTypeHandler
extends BaseTypeHandler<BlobRef>
implements ContentTypeHandler<BlobRef> {
    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, BlobRef parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, this.toPersistableString(parameter));
    }

    public BlobRef getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.nullableBlobRef(rs.getString(columnName));
    }

    public BlobRef getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.nullableBlobRef(rs.getString(columnIndex));
    }

    public BlobRef getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.nullableBlobRef(cs.getString(columnIndex));
    }

    @Nullable
    private BlobRef nullableBlobRef(@Nullable String blobRef) {
        return blobRef != null ? BlobRefTypeHandler.parsePersistableFormat(blobRef) : null;
    }

    public String toPersistableString(BlobRef blobRef) {
        return String.format("%s:%s@%s", blobRef.getStore(), blobRef.getBlob(), blobRef.getNode());
    }

    public static BlobRef parsePersistableFormat(String spec) {
        int colon = spec.indexOf(58);
        int at = spec.lastIndexOf(64);
        if (colon > 0 && at > 0 && at - 1 > colon && at < spec.length() - 1) {
            return new BlobRef(spec.substring(at + 1), spec.substring(0, colon), spec.substring(colon + 1, at));
        }
        throw new IllegalArgumentException("Not a valid blob reference: " + spec);
    }
}

