/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.inject.assistedinject.Assisted;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributesHelper;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.event.asset.AssetAttributesEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDownloadedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetKindEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPreDeleteEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPrePurgeEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.store.AssetDAO;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.ContentStoreEventSupport;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class AssetStore<T extends AssetDAO>
extends ContentStoreEventSupport<T> {
    private static final int LAST_UPDATED_LIMIT = 1000;

    @Inject
    public AssetStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public int countAssets(int repositoryId, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((AssetDAO)this.dao()).countAssets(repositoryId, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<Asset> browseAssets(int repositoryId, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams, int limit) {
        return ((AssetDAO)this.dao()).browseAssets(repositoryId, limit, continuationToken, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<Asset> browseAssets(Set<Integer> repositoryIds, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams, int limit) {
        return ((AssetDAO)this.dao()).browseAssetsInRepositories(repositoryIds, continuationToken, kind, filter, filterParams, limit);
    }

    @Transactional
    public Collection<Asset> browseComponentAssets(Component component) {
        return ((AssetDAO)this.dao()).browseComponentAssets(component);
    }

    @Transactional
    public List<AssetInfo> findUpdatedAssets(int repositoryId, @Nullable OffsetDateTime blobCreated, List<String> regexExpressions, int batchSize) {
        List<AssetInfo> assets;
        OffsetDateTime blobCreatedNormalized = null;
        if (blobCreated != null) {
            blobCreatedNormalized = blobCreated.plus(1L, ChronoUnit.MILLIS).truncatedTo(ChronoUnit.MILLIS);
        }
        if ((assets = ((AssetDAO)this.dao()).findGreaterThanOrEqualToBlobCreated(repositoryId, blobCreatedNormalized, regexExpressions, batchSize + 1)).size() == batchSize + 1) {
            if (this.hasMoreResultsWithSameBlobCreated(assets)) {
                Set knownPaths = assets.stream().map(AssetInfo::path).collect(Collectors.toSet());
                AssetInfo lastAsset = assets.get(assets.size() - 1);
                OffsetDateTime startBlobCreated = lastAsset.blobCreated().truncatedTo(ChronoUnit.MILLIS);
                OffsetDateTime endBlobCreated = lastAsset.blobCreated().plus(1L, ChronoUnit.MILLIS);
                List<AssetInfo> matchBlobCreated = ((AssetDAO)this.dao()).findBlobCreatedWithinRange(repositoryId, startBlobCreated, endBlobCreated, regexExpressions, 1000);
                if (matchBlobCreated.size() == 1000) {
                    this.log.error("Found {} assets with identical last_updated value. Replication is skipping over additional assets with last_updated = {}", (Object)1000, (Object)lastAsset.blobCreated());
                }
                assets.addAll(matchBlobCreated.stream().filter(asset -> !knownPaths.contains(asset.path())).collect(Collectors.toList()));
            } else {
                assets.remove(assets.size() - 1);
            }
        }
        return assets;
    }

    private boolean hasMoreResultsWithSameBlobCreated(List<AssetInfo> assets) {
        OffsetDateTime lastBlobCreated = assets.get(assets.size() - 1).blobCreated().truncatedTo(ChronoUnit.MILLIS);
        OffsetDateTime secondToLastBlobCreated = assets.get(assets.size() - 2).blobCreated().truncatedTo(ChronoUnit.MILLIS);
        return lastBlobCreated.equals(secondToLastBlobCreated);
    }

    @Transactional
    public void createAsset(AssetData asset) {
        ((AssetDAO)this.dao()).createAsset(asset);
        this.postCommitEvent(() -> new AssetCreatedEvent(asset));
    }

    @Transactional
    public Optional<Asset> readAsset(int assetId) {
        return ((AssetDAO)this.dao()).readAsset(assetId);
    }

    @Transactional
    public Optional<Asset> readPath(int repositoryId, String path) {
        return ((AssetDAO)this.dao()).readPath(repositoryId, path);
    }

    @Transactional
    public Optional<Asset> findByBlobRef(int repositoryId, BlobRef blobRef) {
        return ((AssetDAO)this.dao()).findByBlobRef(repositoryId, blobRef);
    }

    @Transactional
    public Collection<AssetInfo> findByComponentIds(Set<Integer> componentIds) {
        if (CollectionUtils.isEmpty(componentIds)) {
            return Collections.emptyList();
        }
        return ((AssetDAO)this.dao()).findByComponentIds(componentIds);
    }

    @Transactional
    public void updateAssetKind(Asset asset) {
        ((AssetDAO)this.dao()).updateAssetKind(asset);
        this.postCommitEvent(() -> new AssetKindEvent(asset));
    }

    @Transactional
    public void updateAssetAttributes(Asset asset, AttributeChangeSet changeSet) {
        ((AssetDAO)this.dao()).readAssetAttributes(asset).ifPresent(attributes -> {
            ((AssetData)asset).setAttributes((NestedAttributesMap)attributes);
            boolean changesApplied = changeSet.getChanges().stream().map(change -> AttributesHelper.applyAttributeChange((AttributesMap)attributes, change)).reduce((a, b) -> a != false || b != false).orElse(false);
            if (changesApplied) {
                ((AssetDAO)this.dao()).updateAssetAttributes(asset);
                this.postCommitEvent(() -> new AssetAttributesEvent(asset, changeSet.getChanges()));
            }
        });
    }

    @Transactional
    public void updateAssetBlobLink(Asset asset) {
        ((AssetDAO)this.dao()).updateAssetBlobLink(asset);
        this.postCommitEvent(() -> new AssetUploadedEvent(asset));
    }

    @Transactional
    public void markAsDownloaded(Asset asset) {
        ((AssetDAO)this.dao()).markAsDownloaded(asset);
        this.postCommitEvent(() -> new AssetDownloadedEvent(asset));
    }

    @Transactional
    public boolean deleteAsset(Asset asset) {
        this.preCommitEvent(() -> new AssetPreDeleteEvent(asset));
        boolean deleted = ((AssetDAO)this.dao()).deleteAsset(asset);
        if (deleted) {
            this.postCommitEvent(() -> new AssetDeletedEvent(asset));
        }
        return deleted;
    }

    @Transactional
    public boolean deletePath(int repositoryId, String path) {
        return ((AssetDAO)this.dao()).readPath(repositoryId, path).map(this::deleteAsset).orElse(false);
    }

    @Transactional
    public int deleteAssetsByPaths(int repositoryId, List<String> paths) {
        if (paths.isEmpty()) {
            return 0;
        }
        Collection<Asset> assets = ((AssetDAO)this.dao()).readPathsFromRepository(repositoryId, paths);
        if (assets.isEmpty()) {
            return 0;
        }
        int[] assetIds = assets.stream().mapToInt(InternalIds::internalAssetId).toArray();
        this.preCommitEvent(() -> new AssetPrePurgeEvent(repositoryId, assetIds));
        this.postCommitEvent(() -> new AssetPurgedEvent(repositoryId, assetIds));
        return this.purgeAssets(assetIds);
    }

    @Transactional
    public boolean deleteAssets(int repositoryId) {
        this.log.debug("Deleting all assets in repository {}", (Object)repositoryId);
        boolean deleted = false;
        while (((AssetDAO)this.dao()).deleteAssets(repositoryId, this.deleteBatchSize())) {
            this.commitChangesSoFar();
            deleted = true;
        }
        this.log.debug("Deleted all assets in repository {}", (Object)repositoryId);
        return deleted;
    }

    @Transactional
    public int purgeNotRecentlyDownloaded(int repositoryId, int daysAgo) {
        int[] assetIds;
        int purged = 0;
        while ((assetIds = ((AssetDAO)this.dao()).selectNotRecentlyDownloaded(repositoryId, daysAgo, this.deleteBatchSize())).length != 0) {
            purged += this.purgeAssets(assetIds);
            this.preCommitEvent(() -> new AssetPrePurgeEvent(repositoryId, assetIds));
            this.postCommitEvent(() -> new AssetPurgedEvent(repositoryId, assetIds));
            this.commitChangesSoFar();
        }
        return purged;
    }

    @Transactional
    public void created(Asset asset, OffsetDateTime created) {
        ((AssetDAO)this.dao()).created(InternalIds.internalAssetId(asset), created);
    }

    @Transactional
    public void lastDownloaded(Asset asset, OffsetDateTime lastDownloaded) {
        ((AssetDAO)this.dao()).lastDownloaded(InternalIds.internalAssetId(asset), lastDownloaded);
    }

    @Transactional
    public void lastUpdated(Asset asset, OffsetDateTime lastUpdated) {
        ((AssetDAO)this.dao()).lastUpdated(InternalIds.internalAssetId(asset), lastUpdated);
    }

    private int purgeAssets(int[] assetIds) {
        if ("H2".equals(this.thisSession().sqlDialect())) {
            return ((AssetDAO)this.dao()).purgeSelectedAssets((Integer[])Arrays.stream(assetIds).boxed().toArray(Integer[]::new));
        }
        return ((AssetDAO)this.dao()).purgeSelectedAssets(assetIds);
    }
}

