/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.inject.assistedinject.Assisted;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.AssetBlobDAO;
import org.sonatype.nexus.repository.content.store.AssetBlobData;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class AssetBlobStore<T extends AssetBlobDAO>
extends ContentStoreSupport<T> {
    @Inject
    public AssetBlobStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public Continuation<AssetBlob> browseUnusedAssetBlobs(int limit, @Nullable String continuationToken) {
        return ((AssetBlobDAO)this.dao()).browseUnusedAssetBlobs(limit, continuationToken);
    }

    @Transactional
    public Continuation<AssetBlob> browseAssetBlobs(int limit, @Nullable String continuationToken) {
        return ((AssetBlobDAO)this.dao()).browseAssetBlobs(limit, continuationToken);
    }

    @Transactional
    public void createAssetBlob(AssetBlobData assetBlob) {
        ((AssetBlobDAO)this.dao()).createAssetBlob(assetBlob);
    }

    @Transactional
    public Optional<AssetBlob> readAssetBlob(BlobRef blobRef) {
        return ((AssetBlobDAO)this.dao()).readAssetBlob(blobRef);
    }

    @Transactional
    public boolean deleteAssetBlob(BlobRef blobRef) {
        return ((AssetBlobDAO)this.dao()).deleteAssetBlob(blobRef);
    }

    @Transactional
    public void setBlobCreated(AssetBlob blob, OffsetDateTime blobCreated) {
        ((AssetBlobDAO)this.dao()).setBlobCreated(blob.blobRef(), blobCreated);
    }
}

