/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.ContinuationAware;
import org.sonatype.nexus.repository.content.AssetBlob;

public class AssetBlobData
implements AssetBlob,
ContinuationAware {
    Integer assetBlobId;
    private BlobRef blobRef;
    private long blobSize;
    private String contentType;
    private Map<String, String> checksums;
    private OffsetDateTime blobCreated;
    @Nullable
    private String createdBy;
    @Nullable
    private String createdByIp;

    @Override
    public BlobRef blobRef() {
        return this.blobRef;
    }

    @Override
    public long blobSize() {
        return this.blobSize;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public Map<String, String> checksums() {
        return this.checksums;
    }

    @Override
    public OffsetDateTime blobCreated() {
        return this.blobCreated;
    }

    @Override
    public Optional<String> createdBy() {
        return Optional.ofNullable(this.createdBy);
    }

    @Override
    public Optional<String> createdByIp() {
        return Optional.ofNullable(this.createdByIp);
    }

    public void setAssetBlobId(int assetBlobId) {
        this.assetBlobId = assetBlobId;
    }

    public void setBlobRef(BlobRef blobRef) {
        this.blobRef = (BlobRef)Preconditions.checkNotNull((Object)blobRef);
    }

    public void setBlobSize(long blobSize) {
        this.blobSize = blobSize;
    }

    public void setContentType(String contentType) {
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
    }

    public void setChecksums(Map<String, String> checksums) {
        this.checksums = (Map)Preconditions.checkNotNull(checksums);
    }

    public void setBlobCreated(OffsetDateTime blobCreated) {
        this.blobCreated = (OffsetDateTime)Preconditions.checkNotNull((Object)blobCreated);
    }

    public void setCreatedBy(@Nullable String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedByIp(@Nullable String createdByIp) {
        this.createdByIp = createdByIp;
    }

    public String nextContinuationToken() {
        return Integer.toString(this.assetBlobId);
    }

    public String toString() {
        return "AssetBlobData{assetBlobId=" + this.assetBlobId + ", blobRef=" + this.blobRef + ", blobSize=" + this.blobSize + ", contentType='" + this.contentType + '\'' + ", checksums=" + this.checksums + ", blobCreated=" + this.blobCreated + ", createdBy='" + this.createdBy + '\'' + ", createdByIp='" + this.createdByIp + '\'' + '}';
    }
}

