/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacetFinder;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class AssetPermissionChecker {
    private final RepositoryManager repositoryManager;
    private final ContentFacetFinder contentFacetFinder;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;

    @Inject
    public AssetPermissionChecker(RepositoryManager repositoryManager, ContentFacetFinder contentFacetFinder, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.contentFacetFinder = (ContentFacetFinder)((Object)Preconditions.checkNotNull((Object)((Object)contentFacetFinder)));
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
    }

    public Stream<Map.Entry<Asset, String>> findPermittedAssets(Collection<? extends Asset> assets, String format, String action) {
        if (assets.isEmpty()) {
            return Stream.empty();
        }
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        List<String> containingRepositoryNames = this.containingRepositoryNames(format, assets.iterator().next());
        return assets.stream().map(asset -> {
            VariableSource source = variableResolverAdapter.fromPath(asset.path(), format);
            return this.findPermittingRepository(containingRepositoryNames, format, action, source).map(r -> new AbstractMap.SimpleImmutableEntry<Asset, String>((Asset)asset, (String)r)).orElse(null);
        }).filter(Objects::nonNull);
    }

    public Optional<String> isPermitted(Asset asset, String format, String action) {
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        List<String> containingRepositoryNames = this.containingRepositoryNames(format, asset);
        VariableSource source = variableResolverAdapter.fromPath(asset.path(), format);
        return this.findPermittingRepository(containingRepositoryNames, format, action, source);
    }

    private Optional<String> findPermittingRepository(List<String> containingRepositoryNames, String format, String action, VariableSource variables) {
        return containingRepositoryNames.stream().filter(r -> this.contentPermissionChecker.isPermitted(r, format, action, variables)).findFirst();
    }

    private List<String> containingRepositoryNames(String format, RepositoryContent repositoryContent) {
        Optional<Repository> repository = this.contentFacetFinder.findRepository(format, repositoryContent);
        if (!repository.isPresent()) {
            return ImmutableList.of();
        }
        String repositoryName = repository.get().getName();
        List containingRepositoryNames = this.repositoryManager.findContainingGroups(repositoryName);
        containingRepositoryNames.add(0, repositoryName);
        return containingRepositoryNames;
    }
}

