/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

public abstract class SearchIndexUpgrade
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String SELECT_REPOSITORIES = "select id, name, recipe_name from repository";
    private static final String SELECT_REPOSITORY_ATTRIBUTES = "select attributes from %s_content_repository where config_repository_id = ?";
    private static final String UPDATE_REPOSITORY_ATTRIBUTES = "update %s_content_repository set attributes = ? where config_repository_id = ?";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String RECIPE_NAME = "recipe_name";
    private final Map<String, Recipe> recipes;

    protected SearchIndexUpgrade(Map<String, Recipe> recipes) {
        this.recipes = recipes;
    }

    public boolean test(String format) {
        return true;
    }

    public void migrate(Connection connection) throws Exception {
        this.log.info("Searching for repositories that need a search index update");
        ObjectMapper objectMapper = new ObjectMapper();
        List<Repo> repos = this.getRepos(connection);
        for (Repo repo : repos) {
            String attributes;
            if (!this.test(repo.format) || (attributes = this.getRepositoryAttributes(connection, repo)) == null) continue;
            ObjectNode json = (ObjectNode)objectMapper.readTree(attributes);
            json.put("search_index_outdated", true);
            this.setRepositoryAttributes(connection, repo, objectMapper.writeValueAsBytes((Object)json));
        }
    }

    private List<Repo> getRepos(Connection connection) throws SQLException {
        ArrayList<Repo> result = new ArrayList<Repo>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement s = connection.createStatement();){
            ResultSet rs = s.executeQuery(SELECT_REPOSITORIES);
            while (rs.next()) {
                String id = rs.getString(ID);
                String name = rs.getString(NAME);
                String recipeName = rs.getString(RECIPE_NAME);
                Recipe recipe = this.recipes.get(recipeName);
                if (recipe != null) {
                    if (recipe.getType() instanceof GroupType) continue;
                    String format = recipe.getFormat().getValue();
                    result.add(new Repo(id, name, format));
                    continue;
                }
                this.log.warn("Unable to upgrade search index because no recipe found {}", (Object)recipeName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Nullable
    private String getRepositoryAttributes(Connection connection, Repo repo) throws SQLException {
        block12: {
            PreparedStatement ps;
            block10: {
                String string;
                block11: {
                    String query = String.format(SELECT_REPOSITORY_ATTRIBUTES, repo.format);
                    Throwable throwable = null;
                    Object var5_6 = null;
                    ps = connection.prepareStatement(query);
                    try {
                        ps.setString(1, repo.id);
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) break block10;
                        string = rs.getString(1);
                        if (ps == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    ps.close();
                }
                return string;
            }
            this.log.warn("Could not find row in {}_content_repository for config_repository_id = {}", (Object)repo.format, (Object)repo.id);
            if (ps == null) break block12;
            ps.close();
        }
        return null;
    }

    private void setRepositoryAttributes(Connection connection, Repo repo, byte[] attributes) throws SQLException {
        this.log.info("Marking {} repository for search index update", (Object)repo.name);
        String update = String.format(UPDATE_REPOSITORY_ATTRIBUTES, repo.format);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement ps = connection.prepareStatement(update);){
            if (this.isH2(connection)) {
                ps.setBytes(1, attributes);
            } else {
                ps.setString(1, new String(attributes, StandardCharsets.UTF_8));
            }
            ps.setString(2, repo.id);
            ps.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class Repo {
        public String id;
        public String name;
        public String format;

        public Repo(String id, String name, String format) {
            this.id = id;
            this.name = name;
            this.format = format;
        }
    }
}

