/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.table;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.SearchResult;
import org.sonatype.nexus.repository.content.search.SearchViewColumns;
import org.sonatype.nexus.repository.content.search.table.SearchTableStore;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.table.TableSearchPermissionManager;
import org.sonatype.nexus.repository.search.table.TableSearchUtils;

@Named
@Singleton
public class SqlTableSearchService
extends ComponentSupport
implements SearchService {
    private final TableSearchUtils searchUtils;
    private final SearchTableStore searchStore;
    private final TableSearchPermissionManager sqlSearchPermissionManager;
    private final Map<String, FormatStoreManager> formatStoreManagersByFormat;

    @Inject
    public SqlTableSearchService(TableSearchUtils searchUtils, SearchTableStore searchStore, Map<String, FormatStoreManager> formatStoreManagersByFormat, TableSearchPermissionManager sqlSearchPermissionManager) {
        this.searchUtils = (TableSearchUtils)Preconditions.checkNotNull((Object)searchUtils);
        this.searchStore = (SearchTableStore)((Object)Preconditions.checkNotNull((Object)((Object)searchStore)));
        this.sqlSearchPermissionManager = (TableSearchPermissionManager)Preconditions.checkNotNull((Object)sqlSearchPermissionManager);
        this.formatStoreManagersByFormat = (Map)Preconditions.checkNotNull(formatStoreManagersByFormat);
    }

    public SearchResponse search(SearchRequest searchRequest) {
        ComponentSearchResultPage searchResultPage = this.searchComponents(searchRequest);
        SearchResponse response = new SearchResponse();
        response.setSearchResults(searchResultPage.componentSearchResults);
        response.setTotalHits(Long.valueOf(searchResultPage.componentSearchResults.size()));
        response.setContinuationToken(String.valueOf(searchResultPage.offset));
        return response;
    }

    public Iterable<ComponentSearchResult> browse(SearchRequest searchRequest) {
        return this.searchComponents(searchRequest).componentSearchResults;
    }

    public long count(SearchRequest searchRequest) {
        SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest);
        return this.searchStore.count(queryCondition);
    }

    private ComponentSearchResultPage searchComponents(SearchRequest searchRequest) {
        SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest);
        return this.doSearch(searchRequest, queryCondition);
    }

    private SqlSearchQueryCondition getSqlSearchQueryCondition(SearchRequest searchRequest) {
        SqlSearchQueryBuilder queryBuilder = this.searchUtils.buildQuery(searchRequest.getSearchFilters());
        this.addPermissionFilters(queryBuilder, searchRequest.getSearchFilters());
        return queryBuilder.buildQuery().orElse(null);
    }

    private void addPermissionFilters(SqlSearchQueryBuilder queryBuilder, List<SearchFilter> searchFilters) {
        this.sqlSearchPermissionManager.addPermissionFilters(queryBuilder, (String)this.searchUtils.getRepositoryFilter(searchFilters).map(SearchFilter::getValue).orElse(null));
    }

    private AssetStore<?> getAssetStore(String format) {
        FormatStoreManager formatStoreManager = this.formatStoreManagersByFormat.get(format);
        return formatStoreManager.assetStore("nexus");
    }

    private ComponentSearchResultPage doSearch(SearchRequest searchRequest, SqlSearchQueryCondition queryCondition) {
        int offset = 0;
        String continuationToken = searchRequest.getContinuationToken();
        try {
            if (continuationToken != null && (offset = Integer.parseInt(continuationToken)) < 0) {
                this.log.error("Continuation token [{}] should be a positive number", (Object)continuationToken);
                return ComponentSearchResultPage.empty();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.error("Continuation token [{}] should be a number", (Object)continuationToken);
            return ComponentSearchResultPage.empty();
        }
        Collection<SearchResult> searchResults = this.searchStore.searchComponents(searchRequest.getLimit(), offset, queryCondition, SearchViewColumns.fromSortFieldName(searchRequest.getSortField()), searchRequest.getSortDirection());
        if (searchResults.isEmpty()) {
            return new ComponentSearchResultPage(0, Collections.emptyList());
        }
        Map<String, List<AssetInfo>> componentIdToAsset = this.getAssetsForComponents(searchResults, searchRequest.isIncludeAssets());
        ArrayList<ComponentSearchResult> componentSearchResults = new ArrayList<ComponentSearchResult>(searchResults.size());
        for (SearchResult component : searchResults) {
            String repositoryName = component.repositoryName();
            ComponentSearchResult componentSearchResult = this.buildComponentSearchResult(component);
            if (searchRequest.isIncludeAssets()) {
                List<AssetInfo> assets = componentIdToAsset.get(this.getFormatComponentKey(component.format(), component.componentId()));
                for (AssetInfo asset : assets) {
                    AssetSearchResult assetSearchResult = this.buildAssetSearch(asset, repositoryName, componentSearchResult.getFormat());
                    componentSearchResult.addAsset(assetSearchResult);
                }
            }
            componentSearchResults.add(componentSearchResult);
        }
        return new ComponentSearchResultPage(searchResults.size(), componentSearchResults);
    }

    private String getFormatComponentKey(String format, Integer componentId) {
        return String.valueOf(format) + componentId;
    }

    private Map<String, List<AssetInfo>> getAssetsForComponents(Collection<SearchResult> searchResults, boolean includeAssets) {
        if (!includeAssets) {
            return Collections.emptyMap();
        }
        Map<String, List<AssetInfo>> componentIdToAsset = new HashMap<String, List<AssetInfo>>();
        HashMap formatComponentIdMap = new HashMap();
        for (SearchResult searchResult : searchResults) {
            if (formatComponentIdMap.containsKey(searchResult.format())) {
                ((List)formatComponentIdMap.get(searchResult.format())).add(searchResult.componentId());
                continue;
            }
            ArrayList<Integer> componentIds = new ArrayList<Integer>();
            componentIds.add(searchResult.componentId());
            formatComponentIdMap.put(searchResult.format(), componentIds);
        }
        for (Map.Entry entry : formatComponentIdMap.entrySet()) {
            AssetStore<?> assetStore = this.getAssetStore((String)entry.getKey());
            Set<Integer> componentIds = searchResults.stream().map(SearchResult::componentId).collect(Collectors.toSet());
            componentIdToAsset = assetStore.findByComponentIds(componentIds).stream().collect(Collectors.groupingBy(assetInfo -> this.getFormatComponentKey((String)stringListEntry.getKey(), assetInfo.componentId())));
        }
        return componentIdToAsset;
    }

    private ComponentSearchResult buildComponentSearchResult(SearchResult searchResult) {
        ComponentSearchResult componentSearchResult = new ComponentSearchResult();
        componentSearchResult.setId(String.valueOf(searchResult.componentId()));
        componentSearchResult.setFormat(searchResult.format());
        componentSearchResult.setRepositoryName(searchResult.repositoryName());
        componentSearchResult.setName(searchResult.componentName());
        componentSearchResult.setGroup(searchResult.namespace());
        componentSearchResult.setVersion(searchResult.version());
        return componentSearchResult;
    }

    private AssetSearchResult buildAssetSearch(AssetInfo asset, String repositoryName, String format) {
        AssetSearchResult searchResult = new AssetSearchResult();
        searchResult.setId(String.valueOf(asset.assetId()));
        searchResult.setPath(asset.path());
        searchResult.setRepository(repositoryName);
        searchResult.setFormat(format);
        searchResult.setLastModified(Date.from(asset.lastUpdated().toInstant()));
        searchResult.setAttributes(asset.attributes().backing());
        searchResult.setContentType(asset.contentType());
        searchResult.setChecksum(asset.checksums());
        return searchResult;
    }

    private static class ComponentSearchResultPage {
        private final int offset;
        private final List<ComponentSearchResult> componentSearchResults;

        public ComponentSearchResultPage(int offset, List<ComponentSearchResult> componentSearchResults) {
            this.offset = offset;
            this.componentSearchResults = (List)Preconditions.checkNotNull(componentSearchResults);
        }

        private static ComponentSearchResultPage empty() {
            return new ComponentSearchResultPage(0, Collections.emptyList());
        }
    }
}

