/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.table;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.event.asset.AssetAttributesEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentKindEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryDeletedEvent;
import org.sonatype.nexus.repository.content.search.table.SearchTableData;
import org.sonatype.nexus.repository.content.search.table.SearchTableStore;
import org.sonatype.nexus.repository.content.search.table.SearchTableSubscriberHelper;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Named
@Singleton
public class SearchTableSubscriber
extends StateGuardLifecycleSupport
implements EventAware {
    private final SearchTableStore store;

    @Inject
    public SearchTableSubscriber(SearchTableStore store) {
        this.store = (SearchTableStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
    }

    @Subscribe
    public void on(AssetCreatedEvent event) {
        Repository repository = event.getRepository().orElse(null);
        if (repository == null) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        Asset asset = event.getAsset();
        Component component = asset.component().orElse(null);
        if (component == null) {
            this.log.debug("Unable to determine component for event {}", (Object)event);
            return;
        }
        AssetBlob blob = asset.blob().orElse(null);
        if (blob == null) {
            this.log.debug("Unable to determine blob for event {}", (Object)event);
            return;
        }
        String format = repository.getFormat().getValue();
        SearchTableData data = new SearchTableData();
        data.setRepositoryId(InternalIds.contentRepositoryId(event));
        data.setComponentId(InternalIds.internalComponentId(component));
        data.setAssetId(InternalIds.internalAssetId(asset));
        data.setFormat(format);
        data.setNamespace(component.namespace());
        data.setComponentName(component.name());
        data.setComponentKind(component.kind());
        data.setVersion(component.version());
        data.setRepositoryName(repository.getName());
        data.setPath(asset.path());
        data.setContentType(blob.contentType());
        data.setMd5(blob.checksums().get(HashAlgorithm.MD5.name()));
        data.setSha1(blob.checksums().get(HashAlgorithm.SHA1.name()));
        data.setSha256(blob.checksums().get(HashAlgorithm.SHA256.name()));
        data.setSha512(blob.checksums().get(HashAlgorithm.SHA512.name()));
        NestedAttributesMap nestedAttributesMap = asset.attributes();
        data.setFormatField1(SearchTableSubscriberHelper.selectFormatField1(format, nestedAttributesMap));
        data.setFormatField2(SearchTableSubscriberHelper.selectFormatField2(format, nestedAttributesMap));
        data.setFormatField3(SearchTableSubscriberHelper.selectFormatField3(format, nestedAttributesMap));
        this.log.trace("Creating a new record into component_search table: {}", (Object)data);
        this.store.create(data);
    }

    @Subscribe
    public void on(ComponentKindEvent event) {
        ComponentData component = (ComponentData)event.getComponent();
        Integer repositoryId = InternalIds.contentRepositoryId(event);
        Integer componentId = InternalIds.internalComponentId(component);
        String format = event.getFormat();
        String componentKind = component.kind();
        this.log.trace("Updating a component kind in component_search table for repositoryId: {}, componentId: {}, format: {}, componentKind: {}", new Object[]{repositoryId, componentId, format, componentKind});
        this.store.updateKind(repositoryId, componentId, format, componentKind);
    }

    @Subscribe
    public void on(AssetDeletedEvent event) {
        Asset asset = event.getAsset();
        Component component = asset.component().orElse(null);
        if (component == null) {
            this.log.debug("Unable to determine component for event {}", (Object)event);
            return;
        }
        Integer repositoryId = InternalIds.contentRepositoryId(event);
        Integer componentId = InternalIds.internalComponentId(component);
        Integer assetId = InternalIds.internalAssetId(asset);
        String format = event.getFormat();
        this.log.trace("Deleting a record from component_search table for repositoryId: {}, componentId: {}, assetId: {}, format: {}", new Object[]{repositoryId, componentId, assetId, format});
        this.store.delete(repositoryId, componentId, assetId, format);
    }

    @Subscribe
    public void on(ContentRepositoryDeletedEvent event) {
        Integer repositoryId = InternalIds.contentRepositoryId(event);
        String format = event.getFormat();
        this.log.trace("Deleting all records from component_search table for repository id: {}, format: {}", (Object)repositoryId, (Object)format);
        this.store.deleteAllForRepository(repositoryId, format);
    }

    @Subscribe
    public void on(AssetAttributesEvent event) {
        Repository repository = event.getRepository().orElse(null);
        if (repository == null) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        Asset asset = event.getAsset();
        Component component = asset.component().orElse(null);
        if (component == null) {
            this.log.debug("Unable to determine component for event {}", (Object)event);
            return;
        }
        Integer repositoryId = InternalIds.contentRepositoryId(event);
        Integer componentId = InternalIds.internalComponentId(component);
        Integer assetId = InternalIds.internalAssetId(asset);
        String format = repository.getFormat().getValue();
        NestedAttributesMap nestedAttributesMap = asset.attributes();
        String formatField1 = SearchTableSubscriberHelper.selectFormatField1(format, nestedAttributesMap);
        String formatField2 = SearchTableSubscriberHelper.selectFormatField2(format, nestedAttributesMap);
        String formatField3 = SearchTableSubscriberHelper.selectFormatField3(format, nestedAttributesMap);
        this.log.trace("Updating format fields in component_search table for repositoryId: {}, componentId: {}, assetId: {}, format: {}, formatField1: {}, formatField2: {}, formatField3: {}", new Object[]{repositoryId, componentId, assetId, format, formatField1, formatField2, formatField3});
        this.store.updateFormatFields(repositoryId, componentId, assetId, format, formatField1, formatField2, formatField3);
    }
}

