/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.table;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.SearchResult;
import org.sonatype.nexus.repository.content.search.SearchViewColumns;
import org.sonatype.nexus.repository.content.search.SqlSearchRequest;
import org.sonatype.nexus.repository.content.search.table.SearchTableDAO;
import org.sonatype.nexus.repository.content.search.table.SearchTableData;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class SearchTableStore
extends ConfigStoreSupport<SearchTableDAO> {
    private final int deleteBatchSize;

    @Inject
    public SearchTableStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.content.deleteBatchSize:-1000}") int deleteBatchSize) {
        super(sessionSupplier, SearchTableDAO.class);
        this.deleteBatchSize = deleteBatchSize;
    }

    @Transactional
    public void create(SearchTableData data) {
        ((SearchTableDAO)this.dao()).create(data);
    }

    @Transactional
    public void updateKind(@Nonnull @Param(value="repositoryId") Integer repositoryId, @Nonnull @Param(value="componentId") Integer componentId, @Nonnull @Param(value="format") String format, @Nonnull @Param(value="componentKind") String componentKind) {
        ((SearchTableDAO)this.dao()).updateKind(repositoryId, componentId, format, componentKind);
    }

    @Transactional
    public void updateFormatFields(@Nonnull @Param(value="repositoryId") Integer repositoryId, @Nonnull @Param(value="componentId") Integer componentId, @Nonnull @Param(value="assetId") Integer assetId, @Nonnull @Param(value="format") String format, @Param(value="formatField1") String formatField1, @Param(value="formatField2") String formatField2, @Param(value="formatField3") String formatField3) {
        ((SearchTableDAO)this.dao()).updateFormatFields(repositoryId, componentId, assetId, format, formatField1, formatField2, formatField3);
    }

    @Transactional
    public void delete(@Nonnull @Param(value="repositoryId") Integer repositoryId, @Nonnull @Param(value="componentId") Integer componentId, @Nonnull @Param(value="assetId") Integer assetId, @Nonnull @Param(value="format") String format) {
        ((SearchTableDAO)this.dao()).delete(repositoryId, componentId, assetId, format);
    }

    @Transactional
    public boolean deleteAllForRepository(Integer repositoryId, String format) {
        boolean deleted = false;
        while (((SearchTableDAO)this.dao()).deleteAllForRepository(repositoryId, format, this.deleteBatchSize)) {
            this.commitChangesSoFar();
            deleted = true;
        }
        return deleted;
    }

    @Transactional
    public Collection<SearchResult> searchComponents(int limit, int offset, @Nullable SqlSearchQueryCondition filterQuery, SearchViewColumns sortColumnName, SortDirection sortDirection) {
        String filterFormat = null;
        Map formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        String direction = Optional.ofNullable(sortDirection).orElse(SortDirection.ASC).name();
        SqlSearchRequest request = SqlSearchRequest.builder().limit(limit).offset(offset).searchFilter(filterFormat).searchFilterValues(formatValues).sortColumnName(sortColumnName.name()).sortDirection(direction).defaultSortColumnName(SearchViewColumns.COMPONENT_ID.name()).build();
        return ((SearchTableDAO)this.dao()).searchComponents(request);
    }

    @Transactional
    public int count(@Nullable SqlSearchQueryCondition filterQuery) {
        String filterFormat = null;
        Map formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        return ((SearchTableDAO)this.dao()).count(filterFormat, formatValues);
    }

    private void commitChangesSoFar() {
        Transaction tx = UnitOfWork.currentTx();
        tx.commit();
        tx.begin();
        CancelableHelper.checkCancellation();
    }
}

