/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.sql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.SearchResult;
import org.sonatype.nexus.repository.content.search.SearchStore;
import org.sonatype.nexus.repository.content.search.SearchViewColumns;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchPermissionException;
import org.sonatype.nexus.repository.search.sql.SqlSearchPermissionManager;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchUtils;

@Named
@Singleton
public class SqlSearchService
extends ComponentSupport
implements SearchService {
    private static final String DELIMITER = "\\s+";
    private final SqlSearchUtils searchUtils;
    private final RepositoryManager repositoryManager;
    private final Map<String, FormatStoreManager> formatStoreManagersByFormat;
    private final SqlSearchPermissionManager sqlSearchPermissionManager;

    @Inject
    public SqlSearchService(SqlSearchUtils searchUtils, RepositoryManager repositoryManager, Map<String, FormatStoreManager> formatStoreManagersByFormat, SqlSearchPermissionManager sqlSearchPermissionManager) {
        this.searchUtils = (SqlSearchUtils)Preconditions.checkNotNull((Object)searchUtils);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.formatStoreManagersByFormat = (Map)Preconditions.checkNotNull(formatStoreManagersByFormat);
        this.sqlSearchPermissionManager = (SqlSearchPermissionManager)Preconditions.checkNotNull((Object)sqlSearchPermissionManager);
    }

    public SearchResponse search(SearchRequest searchRequest) {
        ComponentSearchResultPage searchResultPage = this.executeSearch(() -> this.searchComponents(searchRequest));
        SearchResponse response = new SearchResponse();
        response.setSearchResults(searchResultPage.componentSearchResults);
        response.setTotalHits(Long.valueOf(searchResultPage.componentSearchResults.size()));
        response.setContinuationToken(String.valueOf(searchResultPage.offset));
        return response;
    }

    public Iterable<ComponentSearchResult> browse(SearchRequest searchRequest) {
        return this.executeSearch(() -> this.searchComponents(searchRequest)).componentSearchResults;
    }

    public long count(SearchRequest searchRequest) {
        Optional<String> searchFormatOpt = this.getSearchFormat(searchRequest);
        if (searchFormatOpt.isPresent()) {
            SearchStore<?> searchStore = this.getSearchStore(searchFormatOpt.get());
            return this.executeCount(() -> {
                SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest, (String)searchFormatOpt.get());
                return searchStore.count(queryCondition);
            });
        }
        return 0L;
    }

    private ComponentSearchResultPage searchComponents(SearchRequest searchRequest) {
        Optional<String> searchFormatOpt = this.getSearchFormat(searchRequest);
        if (searchFormatOpt.isPresent()) {
            String searchFormat = searchFormatOpt.get();
            SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest, searchFormat);
            return this.searchByFormat(searchRequest, queryCondition, searchFormat);
        }
        return ComponentSearchResultPage.empty();
    }

    private SqlSearchQueryCondition getSqlSearchQueryCondition(SearchRequest searchRequest, String format) {
        SqlSearchQueryBuilder queryBuilder = this.searchUtils.buildQuery(searchRequest.getSearchFilters());
        this.addPermissionFilters(queryBuilder, searchRequest.getSearchFilters(), format);
        return queryBuilder.buildQuery().orElse(null);
    }

    private void addPermissionFilters(SqlSearchQueryBuilder queryBuilder, List<SearchFilter> searchFilters, String format) {
        this.sqlSearchPermissionManager.addPermissionFilters(queryBuilder, format, (String)this.searchUtils.getRepositoryFilter(searchFilters).map(SearchFilter::getValue).orElse(null));
    }

    private ComponentSearchResultPage executeSearch(Supplier<ComponentSearchResultPage> searchRequest) {
        try {
            return searchRequest.get();
        }
        catch (SqlSearchPermissionException ex) {
            this.log.debug(ex.getMessage());
            return ComponentSearchResultPage.empty();
        }
    }

    private int executeCount(IntSupplier searchRequest) {
        try {
            return searchRequest.getAsInt();
        }
        catch (SqlSearchPermissionException ex) {
            this.log.debug(ex.getMessage());
            return 0;
        }
    }

    private SearchStore<?> getSearchStore(String format) {
        FormatStoreManager formatStoreManager = this.formatStoreManagersByFormat.get(format);
        return formatStoreManager.searchStore("nexus");
    }

    private AssetStore<?> getAssetStore(String format) {
        FormatStoreManager formatStoreManager = this.formatStoreManagersByFormat.get(format);
        return formatStoreManager.assetStore("nexus");
    }

    private ComponentSearchResultPage searchByFormat(SearchRequest searchRequest, SqlSearchQueryCondition queryCondition, String format) {
        int offset = 0;
        String continuationToken = searchRequest.getContinuationToken();
        try {
            if (continuationToken != null && (offset = Integer.parseInt(continuationToken)) < 0) {
                this.log.error("Continuation token [{}] should be a positive number", (Object)continuationToken);
                return ComponentSearchResultPage.empty();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.error("Continuation token [{}] should be a number", (Object)continuationToken);
            return ComponentSearchResultPage.empty();
        }
        SearchStore<?> searchStore = this.getSearchStore(format);
        Collection<SearchResult> searchResults = searchStore.searchComponents(searchRequest.getLimit(), offset, queryCondition, SearchViewColumns.fromSortFieldName(searchRequest.getSortField()), searchRequest.getSortDirection());
        if (searchResults.isEmpty()) {
            return new ComponentSearchResultPage(0, Collections.emptyList());
        }
        Map<Object, Object> componentIdToAsset = new HashMap();
        if (searchRequest.isIncludeAssets()) {
            AssetStore<?> assetStore = this.getAssetStore(format);
            Set<Integer> componentIds = searchResults.stream().map(SearchResult::componentId).collect(Collectors.toSet());
            componentIdToAsset = assetStore.findByComponentIds(componentIds).stream().collect(Collectors.groupingBy(AssetInfo::componentId));
        }
        ArrayList<ComponentSearchResult> componentSearchResults = new ArrayList<ComponentSearchResult>(searchResults.size());
        for (SearchResult component : searchResults) {
            String repositoryName = component.repositoryName();
            ComponentSearchResult componentSearchResult = this.buildComponentSearchResult(component, format);
            if (searchRequest.isIncludeAssets()) {
                List assets = (List)componentIdToAsset.get(component.componentId());
                for (AssetInfo asset : assets) {
                    AssetSearchResult assetSearchResult = this.buildAssetSearch(asset, format, repositoryName);
                    componentSearchResult.addAsset(assetSearchResult);
                }
            }
            componentSearchResults.add(componentSearchResult);
        }
        return new ComponentSearchResultPage(searchResults.size(), componentSearchResults);
    }

    private ComponentSearchResult buildComponentSearchResult(SearchResult searchResult, String format) {
        ComponentSearchResult componentSearchResult = new ComponentSearchResult();
        componentSearchResult.setId(String.valueOf(searchResult.componentId()));
        componentSearchResult.setFormat(format);
        componentSearchResult.setRepositoryName(searchResult.repositoryName());
        componentSearchResult.setName(searchResult.componentName());
        componentSearchResult.setGroup(searchResult.namespace());
        componentSearchResult.setVersion(searchResult.version());
        return componentSearchResult;
    }

    private AssetSearchResult buildAssetSearch(AssetInfo asset, String format, String repositoryName) {
        AssetSearchResult searchResult = new AssetSearchResult();
        searchResult.setId(String.valueOf(asset.assetId()));
        searchResult.setPath(asset.path());
        searchResult.setRepository(repositoryName);
        searchResult.setFormat(format);
        searchResult.setLastModified(Date.from(asset.lastUpdated().toInstant()));
        searchResult.setAttributes(asset.attributes().backing());
        searchResult.setContentType(asset.contentType());
        searchResult.setChecksum(asset.checksums());
        return searchResult;
    }

    private Optional<String> getSearchFormat(SearchRequest searchRequest) {
        HashSet<String> formats = new HashSet<String>();
        searchRequest.getRepositories().forEach(repositoryName -> this.addRepositoryFormat((String)repositoryName, (Set<String>)formats));
        for (SearchFilter searchFilter : searchRequest.getSearchFilters()) {
            String format;
            if ("repository_name".equals(searchFilter.getProperty())) {
                String value = searchFilter.getValue();
                if (Strings2.isEmpty((String)value)) continue;
                Stream.of(value.split(DELIMITER)).forEach(repositoryName -> this.addRepositoryFormat((String)repositoryName, (Set<String>)formats));
                continue;
            }
            if (!"format".equals(searchFilter.getProperty()) || Strings2.isEmpty((String)(format = searchFilter.getValue()))) continue;
            formats.add(format);
        }
        return formats.size() == 1 ? Optional.of((String)formats.iterator().next()) : Optional.empty();
    }

    private void addRepositoryFormat(String repositoryName, Set<String> formats) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            this.log.error("Can't find repository: {}. Search results will not be available for this repository", (Object)repositoryName);
        } else {
            formats.add(repository.getFormat().getValue());
        }
    }

    private static class ComponentSearchResultPage {
        private final int offset;
        private final List<ComponentSearchResult> componentSearchResults;

        public ComponentSearchResultPage(int offset, List<ComponentSearchResult> componentSearchResults) {
            this.offset = offset;
            this.componentSearchResults = (List)Preconditions.checkNotNull(componentSearchResults);
        }

        private static ComponentSearchResultPage empty() {
            return new ComponentSearchResultPage(0, Collections.emptyList());
        }
    }
}

