/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search;

import java.util.Map;
import javax.annotation.Nullable;

public class SqlSearchRequest {
    public final int limit;
    public final int offset;
    @Nullable
    public final String filter;
    @Nullable
    public final Map<String, String> filterParams;
    public final String sortColumnName;
    public final String sortDirection;
    public final String defaultSortColumnName;

    private SqlSearchRequest(Builder builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.filter = builder.filter;
        this.filterParams = builder.filterParams;
        this.sortColumnName = builder.sortColumnName;
        this.sortDirection = builder.sortDirection;
        this.defaultSortColumnName = builder.defaultSortColumnName;
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SqlSearchRequest(Builder builder, SqlSearchRequest sqlSearchRequest) {
        this(builder);
    }

    public static class Builder {
        private int limit;
        private int offset;
        private String filter;
        private Map<String, String> filterParams;
        private String sortColumnName;
        private String sortDirection;
        private String defaultSortColumnName;

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder searchFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder searchFilterValues(Map<String, String> values) {
            this.filterParams = values;
            return this;
        }

        public Builder sortColumnName(String sortColumnName) {
            this.sortColumnName = sortColumnName;
            return this;
        }

        public Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public Builder defaultSortColumnName(String defaultSortColumnName) {
            this.defaultSortColumnName = defaultSortColumnName;
            return this;
        }

        public SqlSearchRequest build() {
            return new SqlSearchRequest(this, null);
        }
    }
}

