/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search;

import java.util.Objects;

public enum SearchViewColumns {
    COMPONENT_ID("componentId"),
    NAMESPACE("namespace"),
    SEARCH_COMPONENT_NAME("componentName"),
    VERSION("version"),
    REPOSITORY_NAME("repositoryName");

    private final String name;

    private SearchViewColumns(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SearchViewColumns fromSortFieldName(String name) {
        if (Objects.isNull(name)) {
            return COMPONENT_ID;
        }
        switch (name) {
            case "group": {
                return NAMESPACE;
            }
            case "id": {
                return COMPONENT_ID;
            }
            case "name": {
                return SEARCH_COMPONENT_NAME;
            }
            case "version": {
                return VERSION;
            }
        }
        return COMPONENT_ID;
    }
}

