/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search;

import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.SearchResult;
import org.sonatype.nexus.repository.content.search.SearchDAO;
import org.sonatype.nexus.repository.content.search.SearchViewColumns;
import org.sonatype.nexus.repository.content.search.SqlSearchRequest;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class SearchStore<T extends SearchDAO>
extends ContentStoreSupport<T> {
    @Inject
    public SearchStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public Collection<SearchResult> searchComponents(int limit, int offset, @Nullable SqlSearchQueryCondition filterQuery, SearchViewColumns sortColumnName, SortDirection sortDirection) {
        String filterFormat = null;
        Map formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        String direction = Optional.ofNullable(sortDirection).orElse(SortDirection.ASC).name();
        SqlSearchRequest request = SqlSearchRequest.builder().limit(limit).offset(offset).searchFilter(filterFormat).searchFilterValues(formatValues).sortColumnName(sortColumnName.name()).sortDirection(direction).defaultSortColumnName(SearchViewColumns.COMPONENT_ID.name()).build();
        return ((SearchDAO)this.dao()).searchComponents(request);
    }

    @Transactional
    public int count(@Nullable SqlSearchQueryCondition filterQuery) {
        String filterFormat = null;
        Map formatValues = null;
        if (Objects.nonNull(filterQuery)) {
            filterFormat = filterQuery.getSqlConditionFormat();
            formatValues = filterQuery.getValues();
        }
        return ((SearchDAO)this.dao()).count(filterFormat, formatValues);
    }
}

