/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search;

import com.codahale.metrics.annotation.Gauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUpdatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentUpdatedEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@FeatureFlag(name="nexus.datastore.enabled")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class SearchEventHandler
extends LifecycleSupport
implements EventAware {
    private static final String HANDLER_KEY_PREFIX = "nexus.search.event.handler.";
    private static final String FLUSH_ON_COUNT_KEY = "nexus.search.event.handler.flushOnCount";
    private static final String FLUSH_ON_SECONDS_KEY = "nexus.search.event.handler.flushOnSeconds";
    private static final String NO_PURGE_DELAY_KEY = "nexus.search.event.handler.noPurgeDelay";
    private static final String FLUSH_POOL_SIZE = "nexus.search.event.handler.flushPoolSize";
    private final RepositoryManager repositoryManager;
    private final PeriodicJobService periodicJobService;
    private final int flushOnCount;
    private final int flushOnSeconds;
    private final boolean noPurgeDelay;
    private final Map<String, String> pendingRequests = new ConcurrentHashMap<String, String>();
    private final AtomicInteger pendingCount = new AtomicInteger();
    private final int poolSize;
    private ThreadPoolExecutor threadPoolExecutor;
    private Object flushMutex = new Object();
    private PeriodicJobService.PeriodicJob flushTask;
    private boolean processEvents = true;

    @Inject
    public SearchEventHandler(RepositoryManager repositoryManager, PeriodicJobService periodicJobService, @Named(value="${nexus.search.event.handler.flushOnCount:-100}") int flushOnCount, @Named(value="${nexus.search.event.handler.flushOnSeconds:-2}") int flushOnSeconds, @Named(value="${nexus.search.event.handler.noPurgeDelay:-true}") boolean noPurgeDelay, @Named(value="${nexus.search.event.handler.flushPoolSize:-128}") int poolSize) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        Preconditions.checkArgument((flushOnCount > 0 ? 1 : 0) != 0, (Object)"nexus.search.event.handler.flushOnCount must be positive");
        this.flushOnCount = flushOnCount;
        Preconditions.checkArgument((flushOnSeconds > 0 ? 1 : 0) != 0, (Object)"nexus.search.event.handler.flushOnSeconds must be positive");
        this.flushOnSeconds = flushOnSeconds;
        this.noPurgeDelay = noPurgeDelay;
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be greater than zero");
        this.poolSize = poolSize;
    }

    protected void doStart() throws Exception {
        if (this.flushOnCount > 1) {
            this.periodicJobService.startUsing();
            this.flushTask = this.periodicJobService.schedule(this::pollSearchUpdateRequest, this.flushOnSeconds);
        }
        this.threadPoolExecutor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NexusThreadFactory("searchEventHandler", "flushAndPurge", 1), new ThreadPoolExecutor.AbortPolicy());
    }

    protected void doStop() throws Exception {
        if (this.flushOnCount > 1) {
            this.flushTask.cancel();
            this.periodicJobService.stopUsing();
        }
        this.threadPoolExecutor.shutdownNow();
    }

    @Gauge(name="nexus.search.eventHandler.executor.queueSize")
    public int searchEventQueue() {
        return this.threadPoolExecutor.getQueue().size();
    }

    public void setProcessEvents(boolean processEvents) {
        this.processEvents = processEvents;
    }

    public void requestIndex(String format, int componentId, Repository repository) {
        if (this.processEvents && componentId > 0) {
            this.markComponentAsPending(SearchEventHandler.requestKey(format, componentId), SearchEventHandler.repoTag(RequestType.INDEX, repository));
            this.maybeTriggerAsyncFlush();
        }
    }

    public void requestPurge(String format, int componentId, Repository repository) {
        if (this.processEvents && componentId > 0) {
            this.markComponentAsPending(SearchEventHandler.requestKey(format, componentId), SearchEventHandler.repoTag(RequestType.PURGE, repository));
            this.maybeTriggerAsyncPurge();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentCreatedEvent event) {
        this.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentUpdatedEvent event) {
        this.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) {
        this.requestPurge(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetCreatedEvent event) {
        this.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetUpdatedEvent event) {
        this.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetDeletedEvent event) {
        this.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(UploadManager.UIUploadEvent event) {
        SearchEventHandler.indexUIUpload(event.getRepository(), event.getAssetPaths());
    }

    @VisibleForTesting
    static void indexUIUpload(Repository repository, List<String> assetPaths) {
        repository.optionalFacet(SearchFacet.class).ifPresent(searchFacet -> repository.optionalFacet(ContentFacet.class).ifPresent(contentFacet -> SearchEventHandler.processUIUpload(assetPaths, contentFacet, searchFacet)));
    }

    private static void processUIUpload(List<String> assetPaths, ContentFacet contentFacet, SearchFacet searchFacet) {
        List<EntityId> componentIds = assetPaths.stream().map(assetPath -> SearchEventHandler.getComponentEntityId(assetPath, contentFacet)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!componentIds.isEmpty()) {
            searchFacet.index(componentIds);
        }
    }

    private static Optional<EntityId> getComponentEntityId(String assetPath, ContentFacet contentFacet) {
        return contentFacet.assets().path(assetPath).find().map(InternalIds::internalComponentId).filter(OptionalInt::isPresent).map(OptionalInt::getAsInt).map(InternalIds::toExternalId);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentPurgedEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        String format = repository.get().getFormat().getValue();
        String repoTag = SearchEventHandler.repoTag(RequestType.PURGE, repository.get());
        int[] nArray = event.getComponentIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int componentId = nArray[n2];
            this.markComponentAsPending(SearchEventHandler.requestKey(format, componentId), repoTag);
            ++n2;
        }
        this.maybeTriggerAsyncPurge();
    }

    private void requestIndex(ComponentEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        this.requestIndex(event.getFormat(), InternalIds.internalComponentId(event.getComponent()), repository.get());
    }

    private void requestPurge(ComponentDeletedEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        this.requestPurge(event.getFormat(), InternalIds.internalComponentId(event.getComponent()), repository.get());
    }

    private void requestIndex(AssetEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Unable to determine repository for event {}", (Object)event);
            return;
        }
        this.requestIndex(event.getFormat(), InternalIds.internalComponentId(event.getAsset()).orElse(-1), repository.get());
    }

    private void markComponentAsPending(String requestKey, String repoTag) {
        if (this.pendingRequests.put(requestKey, repoTag) == null) {
            this.pendingCount.getAndIncrement();
        }
    }

    private boolean maybeTriggerAsyncFlush() {
        if (this.pendingCount.getAndUpdate(c -> c >= this.flushOnCount ? c - this.flushOnCount : c) >= this.flushOnCount) {
            this.threadPoolExecutor.execute(() -> this.flushPageOfComponents(null));
            return true;
        }
        return false;
    }

    private boolean maybeTriggerAsyncPurge() {
        if (!this.maybeTriggerAsyncFlush() && this.noPurgeDelay) {
            this.threadPoolExecutor.execute(() -> this.flushPageOfComponents(RequestType.PURGE));
            return true;
        }
        return false;
    }

    void pollSearchUpdateRequest() {
        if (this.pendingCount.get() > 0) {
            this.flushPageOfComponents(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushPageOfComponents(@Nullable RequestType requestType) {
        ArrayListMultimap requestsByRepository = ArrayListMultimap.create();
        Object object = this.flushMutex;
        synchronized (object) {
            Iterator<Map.Entry<String, String>> itr = this.pendingRequests.entrySet().iterator();
            int i = 0;
            while (i < this.flushOnCount && itr.hasNext()) {
                Map.Entry<String, String> entry = itr.next();
                if (requestType == null || entry.getValue().startsWith(requestType.name())) {
                    requestsByRepository.put((Object)entry.getValue(), (Object)SearchEventHandler.componentId(entry.getKey()));
                    itr.remove();
                }
                ++i;
            }
        }
        requestsByRepository.asMap().forEach((repoTag, componentIds) -> Optional.ofNullable(this.repositoryManager.get(SearchEventHandler.repositoryName(repoTag))).ifPresent(repository -> repository.optionalFacet(SearchFacet.class).ifPresent(searchFacet -> {
            if (repoTag.startsWith(RequestType.INDEX.name())) {
                searchFacet.index((Collection<EntityId>)componentIds);
            } else {
                searchFacet.purge((Collection<EntityId>)componentIds);
            }
        })));
    }

    @VisibleForTesting
    public boolean isCalmPeriod() {
        return this.threadPoolExecutor.getQueue().isEmpty() && this.threadPoolExecutor.getActiveCount() == 0;
    }

    private static String requestKey(String format, int componentId) {
        return String.valueOf(format) + ':' + componentId;
    }

    private static EntityId componentId(String requestKey) {
        return InternalIds.toExternalId(Integer.parseInt(requestKey.substring(requestKey.indexOf(58) + 1)));
    }

    private static String repoTag(RequestType requestType, Repository repository) {
        return String.valueOf(requestType.name()) + ':' + repository.getName();
    }

    private static String repositoryName(String repoTag) {
        return repoTag.substring(repoTag.indexOf(58) + 1);
    }

    static enum RequestType {
        INDEX,
        PURGE;

    }
}

