/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.content.rest.AssetXOBuilder;
import org.sonatype.nexus.repository.content.rest.internal.resources.ComponentsResourceSupport;
import org.sonatype.nexus.repository.content.rest.internal.resources.doc.ComponentsResourceDoc;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;
import org.sonatype.nexus.repository.upload.UploadConfiguration;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
@Path(value="/v1/components")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ComponentsResource
extends ComponentsResourceSupport
implements Resource,
ComponentsResourceDoc {
    public static final String RESOURCE_URI = "/v1/components";
    static final int PAGE_SIZE = 10;
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final MaintenanceService maintenanceService;
    private final UploadManager uploadManager;
    private final UploadConfiguration uploadConfiguration;
    private final ComponentXOFactory componentXOFactory;
    private final Map<String, AssetXODescriptor> assetDescriptors;

    @Inject
    public ComponentsResource(RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, MaintenanceService maintenanceService, UploadManager uploadManager, UploadConfiguration uploadConfiguration, ComponentXOFactory componentXOFactory, ContentAuthHelper contentAuthHelper, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        super(contentAuthHelper, repositoryManagerRESTAdapter);
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.uploadConfiguration = (UploadConfiguration)Preconditions.checkNotNull((Object)uploadConfiguration);
        this.componentXOFactory = (ComponentXOFactory)Preconditions.checkNotNull((Object)componentXOFactory);
        this.assetDescriptors = assetDescriptors;
    }

    @Override
    @GET
    public Page<ComponentXO> getComponents(@QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="repository") String repositoryId) {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        List<FluentComponent> components = this.browse(repository, continuationToken);
        return new Page(this.toComponentXOs(components, repository), ComponentsResource.nextContinuationToken(components));
    }

    @Override
    @GET
    @Path(value="/{id}")
    public ComponentXO getComponentById(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIDXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIDXO.getRepositoryId());
        return this.fromComponent(this.getComponent(repositoryItemIDXO, repository), repository);
    }

    private FluentComponent getComponent(RepositoryItemIDXO repositoryItemIDXO, Repository repository) {
        try {
            return ((ContentFacet)repository.facet(ContentFacet.class)).components().find((EntityId)new DetachedEntityId(repositoryItemIDXO.getId())).filter(this.componentPermitted(repository.getFormat().getValue(), repository.getName())).orElseThrow(() -> new NotFoundException("Unable to locate component with id " + repositoryItemIDXO.getValue()));
        }
        catch (IllegalArgumentException e) {
            this.log.debug("IllegalArgumentException caught retrieving component with id {}", (Object)repositoryItemIDXO.getId(), (Object)e);
            throw new WebApplicationException(String.format("Unable to process component with id %s", repositoryItemIDXO.getId()), 422);
        }
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public void deleteComponent(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIdXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIdXO.getRepositoryId());
        Optional.ofNullable(repository).map(r -> this.getComponent(repositoryItemIdXO, (Repository)r)).ifPresent(c -> {
            Set<String> set = this.maintenanceService.deleteComponent(repository, (Component)c);
        });
    }

    @Override
    @POST
    @Consumes(value={"multipart/form-data"})
    public void uploadComponent(@QueryParam(value="repository") String repositoryId, @Context HttpServletRequest request) throws IOException {
        if (!this.uploadConfiguration.isEnabled()) {
            throw new WebApplicationException(404);
        }
        if (request.getContentType() == null || !request.getContentType().startsWith("multipart/")) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Expected multipart Content-Type\"", "application/json");
        }
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        try {
            this.uploadManager.handle(repository, request);
        }
        catch (IllegalOperationException e) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    private List<ComponentXO> toComponentXOs(List<FluentComponent> components, Repository repository) {
        return components.stream().map(component -> this.fromComponent((FluentComponent)component, repository)).collect(Collectors.toList());
    }

    private ComponentXO fromComponent(FluentComponent component, Repository repository) {
        String externalId = InternalIds.toExternalId(InternalIds.internalComponentId(component)).getValue();
        ComponentXO componentXO = this.componentXOFactory.createComponentXO();
        componentXO.setAssets(component.assets().stream().filter(this.assetPermitted(repository)).map(asset -> AssetXOBuilder.fromAsset(asset, repository, this.assetDescriptors)).collect(Collectors.toList()));
        componentXO.setGroup(component.namespace());
        componentXO.setName(component.name());
        componentXO.setVersion(component.version());
        componentXO.setId(new RepositoryItemIDXO(repository.getName(), externalId).getValue());
        componentXO.setRepository(repository.getName());
        componentXO.setFormat(repository.getFormat().getValue());
        return componentXO;
    }

    private static String nextContinuationToken(List<FluentComponent> components) {
        int size = components.size();
        return size < 10 ? null : InternalIds.toExternalId(InternalIds.internalComponentId(components.get(size - 1))).getValue();
    }
}

