/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;

abstract class AssetsResourceSupport
extends ComponentSupport {
    protected static final int LIMIT = 100;
    private final ContentAuthHelper contentAuthHelper;

    AssetsResourceSupport(ContentAuthHelper contentAuthHelper) {
        this.contentAuthHelper = (ContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
    }

    List<FluentAsset> browse(Repository repository, String continuationToken) {
        ArrayList<FluentAsset> permittedAssets = new ArrayList<FluentAsset>();
        String internalToken = AssetsResourceSupport.toInternalToken(continuationToken);
        Continuation<FluentAsset> assetContinuation = this.getAssets(repository, internalToken);
        while (permittedAssets.size() < 10 && !assetContinuation.isEmpty()) {
            permittedAssets.addAll(this.removeAssetsNotPermitted(repository, assetContinuation));
            assetContinuation = this.getAssets(repository, assetContinuation.nextContinuationToken());
        }
        return AssetsResourceSupport.trim(permittedAssets, 10);
    }

    private Continuation<FluentAsset> getAssets(Repository repository, String continuationToken) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().browse(100, continuationToken);
    }

    private List<FluentAsset> removeAssetsNotPermitted(Repository repository, Continuation<FluentAsset> assets) {
        return assets.stream().filter(this.assetPermitted(repository.getFormat().getValue(), repository.getName())).collect(Collectors.toList());
    }

    Predicate<FluentAsset> assetPermitted(String format, String ... repositoryNames) {
        return asset -> this.contentAuthHelper.checkPathPermissions(asset.path(), format, repositoryNames);
    }

    static String toInternalToken(String continuationToken) {
        if (continuationToken != null) {
            return String.valueOf(InternalIds.toInternalId(EntityHelper.id((String)continuationToken)));
        }
        return null;
    }

    static <T> List<T> trim(List<T> items, int limit) {
        if (items.size() > limit) {
            items = items.subList(0, limit);
        }
        return items;
    }
}

