/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.rest;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;

public class AssetXOBuilder {
    public static AssetXO fromAsset(Asset asset, Repository repository, Map<String, AssetXODescriptor> assetDescriptors) {
        String externalId = InternalIds.toExternalId(InternalIds.internalAssetId(asset)).getValue();
        Optional<AssetBlob> assetBlob = asset.blob();
        Map checksum = assetBlob.map(AssetBlob::checksums).orElseGet(Collections::emptyMap);
        String contentType = assetBlob.map(AssetBlob::contentType).orElse(null);
        String format = repository.getFormat().getValue();
        String uploader = assetBlob.flatMap(AssetBlob::createdBy).orElse(null);
        String uploaderIp = assetBlob.flatMap(AssetBlob::createdByIp).orElse(null);
        long fileSize = assetBlob.map(AssetBlob::blobSize).orElse(0L);
        Date lastModified = assetBlob.map(AssetBlob::blobCreated).map(OffsetDateTime::toInstant).map(Date::from).orElseGet(() -> Date.from(asset.created().toInstant()));
        return AssetXO.builder().path(asset.path()).downloadUrl(String.valueOf(repository.getUrl()) + asset.path()).id(new RepositoryItemIDXO(repository.getName(), externalId).getValue()).repository(repository.getName()).checksum(checksum).format(format).contentType(contentType).lastModified(lastModified).lastDownloaded(AssetXOBuilder.getLastDownloaded(asset)).attributes(AssetXOBuilder.getExpandedAttributes(asset, format, assetDescriptors)).uploader(uploader).uploaderIp(uploaderIp).fileSize(fileSize).build();
    }

    @Nullable
    private static Date getLastDownloaded(Asset asset) {
        return asset.lastDownloaded().map(offsetDateTime -> Date.from(offsetDateTime.toInstant())).orElse(null);
    }

    private static Map<String, Object> getExpandedAttributes(Asset asset, String format, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        Set exposedAttributeKeys = Optional.ofNullable(assetDescriptors).map(ad -> (AssetXODescriptor)ad.get(format)).map(AssetXODescriptor::listExposedAttributeKeys).orElseGet(Collections::emptySet);
        Map<String, Object> exposedAttributes = asset.attributes(format).backing().entrySet().stream().filter(entry -> exposedAttributeKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Collections.singletonMap(format, exposedAttributes);
    }
}

