/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.replication;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.replication.ReplicationFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.ReplicationIngesterHelper;
import org.sonatype.nexus.repository.replication.ReplicationIngestionException;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class ReplicationIngesterHelperImpl
extends ComponentSupport
implements ReplicationIngesterHelper {
    protected final RepositoryManager repositoryManager;
    protected final BlobStoreManager blobStoreManager;

    @Inject
    public ReplicationIngesterHelperImpl(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    public void replicate(String blobStoreId, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes, String repositoryName, String blobStoreName) throws IOException {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ReplicationIngestionException(String.format("Can't replicate blob %s as the repository %s doesn't exist", blob.getId().toString(), repositoryName));
        }
        BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
        BlobAttributes blobAttributes = blobStore.getBlobAttributes(blob.getId());
        blobAttributes.getHeaders().put("Bucket.repo-name", repositoryName);
        blobAttributes.store();
        String path = this.normalizePath((String)blobAttributes.getHeaders().get("BlobStore.blob-name"));
        ReplicationFacet replicationFacet = (ReplicationFacet)repository.facet(ReplicationFacet.class);
        replicationFacet.replicate(path, blob, assetAttributes, componentAttributes);
    }

    public void deleteReplication(String path, String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ReplicationIngestionException(String.format("Can't delete blob in path %s, the repository %s doesn't exist", path, repositoryName));
        }
        ReplicationFacet replicationFacet = (ReplicationFacet)repository.facet(ReplicationFacet.class);
        replicationFacet.replicateDelete(this.normalizePath(path));
    }

    private String normalizePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

