/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.replication;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.ReplicationMarker;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.replication.ReplicationFacet;

public abstract class ReplicationFacetSupport
extends FacetSupport
implements ReplicationFacet {
    @Override
    public void replicate(String path, Blob blob, Map<String, Object> assetAttributes, @Nullable Map<String, Object> componentAttributes) {
        try {
            ReplicationMarker.set((boolean)true);
            this.doReplicate(path, blob, assetAttributes, componentAttributes);
        }
        finally {
            ReplicationMarker.unset();
        }
    }

    @Override
    public boolean replicateDelete(String path) {
        try {
            ReplicationMarker.set((boolean)true);
            boolean bl = this.doReplicateDelete(path);
            return bl;
        }
        finally {
            ReplicationMarker.unset();
        }
    }

    public abstract void doReplicate(String var1, Blob var2, Map<String, Object> var3, @Nullable Map<String, Object> var4);

    public boolean doReplicateDelete(String path) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        ContentMaintenanceFacet componentMaintenance = (ContentMaintenanceFacet)this.facet(ContentMaintenanceFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        Optional<FluentAsset> result = fluentAssets.path(path).find();
        result.ifPresent(componentMaintenance::deleteAsset);
        return result.isPresent();
    }
}

