/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.maintenance.internal;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.MissingFacetException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.content.maintenance.internal.DeleteFolderService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class MaintenanceServiceImpl
extends ComponentSupport
implements MaintenanceService {
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private final DeleteFolderService deleteFolderService;
    private final ExecutorService executorService;

    @Inject
    public MaintenanceServiceImpl(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, RepositoryPermissionChecker repositoryPermissionChecker, DeleteFolderService deleteFolderService, ExecutorService executorService) {
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)Preconditions.checkNotNull((Object)repositoryPermissionChecker);
        this.deleteFolderService = (DeleteFolderService)Preconditions.checkNotNull((Object)deleteFolderService);
        this.executorService = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new NexusThreadFactory("delete-path", "Delete path in Tree Browse View", 1)));
    }

    @Override
    public Set<String> deleteAsset(Repository repository, Asset asset) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)asset);
        if (!this.canDeleteAsset(repository, asset)) {
            throw new AuthorizationException();
        }
        return this.maintenanceFacet(repository).deleteAsset(asset);
    }

    @Override
    public Set<String> deleteComponent(Repository repository, Component component) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)component);
        if (!this.canDeleteComponent(repository, component)) {
            throw new AuthorizationException();
        }
        return this.maintenanceFacet(repository).deleteComponent(component);
    }

    @Override
    public void deleteFolder(Repository repository, String path) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)path);
        if (!this.canDeleteFolder(repository, path)) {
            throw new AuthorizationException();
        }
        this.executorService.submit(() -> this.deleteFolderService.deleteFolder(repository, path, OffsetDateTime.now()));
    }

    @Override
    public boolean canDeleteComponent(Repository repository, Component component) {
        boolean canDeleteComponent = true;
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        for (Asset asset : contentFacet.components().with(component).assets()) {
            if (this.canDeleteAssetInRepository(repositoryName, format, variableResolverAdapter, asset)) continue;
            canDeleteComponent = false;
            break;
        }
        return canDeleteComponent;
    }

    @Override
    public boolean canDeleteAsset(Repository repository, Asset asset) {
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        return this.canDeleteAssetInRepository(repositoryName, format, this.variableResolverAdapterManager.get(format), asset);
    }

    @Override
    public boolean canDeleteFolder(Repository repository, String folder) {
        return this.repositoryPermissionChecker.userCanDeleteInRepository(repository);
    }

    private boolean canDeleteAssetInRepository(String repositoryName, String format, VariableResolverAdapter variableResolverAdapter, Asset asset) {
        VariableSource source = variableResolverAdapter.fromPath(asset.path(), format);
        return this.contentPermissionChecker.isPermitted(repositoryName, format, "delete", source);
    }

    private ContentMaintenanceFacet maintenanceFacet(Repository repository) {
        try {
            return (ContentMaintenanceFacet)repository.facet(ContentMaintenanceFacet.class);
        }
        catch (MissingFacetException e) {
            throw new IllegalOperationException(String.format("Deleting from repository %s of type %s is not supported", repository.getName(), repository.getFormat()), (Throwable)e);
        }
    }
}

