/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.maintenance.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.time.OffsetDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.node.BrowseNodeQueryService;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.maintenance.internal.DeleteFolderService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class DeleteFolderServiceImpl
extends ComponentSupport
implements DeleteFolderService {
    private final BrowseNodeQueryService browseNodeQueryService;
    private final BrowseNodeConfiguration configuration;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final SecurityHelper securityHelper;

    @Inject
    public DeleteFolderServiceImpl(BrowseNodeQueryService browseNodeQueryService, BrowseNodeConfiguration configuration, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, SecurityHelper securityHelper) {
        this.browseNodeQueryService = (BrowseNodeQueryService)Preconditions.checkNotNull((Object)browseNodeQueryService);
        this.configuration = (BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @Override
    public void deleteFolder(Repository repository, String treePath, OffsetDateTime timestamp) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        ContentMaintenanceFacet contentMaintenance = (ContentMaintenanceFacet)repository.facet(ContentMaintenanceFacet.class);
        int maxNodes = this.configuration.getMaxNodes();
        boolean canDeleteComponent = this.securityHelper.isPermitted(new Permission[]{new RepositoryViewPermission(repository, new String[]{"delete"})})[0];
        PriorityQueue<String> pathQueue = new PriorityQueue<String>();
        pathQueue.add(treePath);
        while (CancelableHelper.checkCancellation() && !pathQueue.isEmpty()) {
            String nodePath = (String)pathQueue.poll();
            List pathSegments = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)nodePath);
            Iterable nodes = this.browseNodeQueryService.getByPath(repository, pathSegments, maxNodes);
            Iterator nodeIterator = nodes.iterator();
            while (CancelableHelper.checkCancellation() && nodeIterator.hasNext()) {
                BrowseNode node = (BrowseNode)nodeIterator.next();
                if (!node.isLeaf()) {
                    pathQueue.offer(String.valueOf(nodePath) + "/" + node.getName());
                } else if (canDeleteComponent && node.getAssetId() == null && node.getComponentId() != null) {
                    contentFacet.components().find(node.getComponentId()).ifPresent(component -> this.deleteComponent((FluentComponent)component, timestamp, contentMaintenance));
                }
                if (node.getAssetId() == null) continue;
                contentFacet.assets().find(node.getAssetId()).ifPresent(asset -> this.deleteAsset(repository, (FluentAsset)asset, timestamp, contentMaintenance));
            }
        }
    }

    private void deleteComponent(FluentComponent component, OffsetDateTime timestamp, ContentMaintenanceFacet contentMaintenance) {
        OffsetDateTime lastUpdated = component.lastUpdated();
        if (timestamp.isAfter(lastUpdated)) {
            contentMaintenance.deleteComponent(component);
        }
    }

    private void deleteAsset(Repository repository, FluentAsset asset, OffsetDateTime timestamp, ContentMaintenanceFacet contentMaintenance) {
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        if (timestamp.isAfter(asset.blob().map(AssetBlob::blobCreated).orElse(OffsetDateTime.now())) && this.canDeleteAsset(repositoryName, format, variableResolverAdapter, asset)) {
            try {
                contentMaintenance.deleteAsset(asset);
            }
            catch (Exception e) {
                this.log.error("Failed to delete an asset - skipping.", (Throwable)e);
            }
        }
    }

    private boolean canDeleteAsset(String repositoryName, String format, VariableResolverAdapter variableResolverAdapter, Asset asset) {
        VariableSource source = variableResolverAdapter.fromPath(asset.path(), format);
        return this.contentPermissionChecker.isPermitted(repositoryName, format, "delete", source);
    }
}

