/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.maintenance;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.ComponentStore;

@Named
public class DefaultMaintenanceFacet
extends FacetSupport
implements ContentMaintenanceFacet {
    @Override
    public Set<String> deleteComponent(Component component) {
        ImmutableSet.Builder deletedPaths = ImmutableSet.builder();
        FluentComponent componentToDelete = this.contentFacet().components().with(component);
        componentToDelete.assets().forEach(assetToDelete -> {
            if (assetToDelete.delete()) {
                deletedPaths.add((Object)assetToDelete.path());
            }
        });
        componentToDelete.delete();
        return deletedPaths.build();
    }

    @Override
    public Set<String> deleteAsset(Asset asset) {
        ImmutableSet.Builder deletedPaths = ImmutableSet.builder();
        FluentAsset assetToDelete = this.contentFacet().assets().with(asset);
        if (assetToDelete.delete()) {
            deletedPaths.add((Object)assetToDelete.path());
        }
        return deletedPaths.build();
    }

    protected ContentFacet contentFacet() {
        return (ContentFacet)this.facet(ContentFacet.class);
    }

    @Override
    public int deleteComponents(int[] componentIds) {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.contentFacet();
        ComponentStore<?> componentStore = contentFacet.stores().componentStore;
        return componentStore.purge(contentFacet.contentRepositoryId(), componentIds);
    }
}

