/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentBuilderImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentQueryImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentContinuation;
import org.sonatype.nexus.repository.content.fluent.internal.RepositoryContentUtil;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.GroupType;

public class FluentComponentsImpl
implements FluentComponents {
    private final ContentFacetSupport facet;
    private final ComponentStore<?> componentStore;

    public FluentComponentsImpl(ContentFacetSupport facet, ComponentStore<?> componentStore) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.componentStore = (ComponentStore)((Object)Preconditions.checkNotNull(componentStore));
    }

    @Override
    public FluentComponentBuilder name(String name) {
        return new FluentComponentBuilderImpl(this.facet, this.componentStore, name);
    }

    @Override
    public FluentComponent with(Component component) {
        return component instanceof FluentComponent ? (FluentComponent)component : new FluentComponentImpl(this.facet, component);
    }

    @Override
    public int count() {
        return this.doCount(null, null, null);
    }

    int doCount(@Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return this.componentStore.countComponents(this.facet.contentRepositoryId(), kind, filter, filterParams);
    }

    @Override
    public Continuation<FluentComponent> browse(int limit, String continuationToken) {
        return this.doBrowse(limit, continuationToken, null, null, null);
    }

    Continuation<FluentComponent> doBrowse(int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        Set<Integer> leafRepositoryIds;
        if (RepositoryContentUtil.isGroupRepository(this.facet.repository()) && !(leafRepositoryIds = RepositoryContentUtil.getLeafRepositoryIds(this.facet.repository())).isEmpty()) {
            return new FluentContinuation(this.componentStore.browseComponents(leafRepositoryIds, limit, continuationToken), this::with);
        }
        return new FluentContinuation(this.componentStore.browseComponents(this.facet.contentRepositoryId(), limit, continuationToken, kind, filter, filterParams), this::with);
    }

    @Override
    public FluentQuery<FluentComponent> byKind(String kind) {
        return new FluentComponentQueryImpl(this, kind);
    }

    @Override
    public FluentQuery<FluentComponent> byFilter(String filter, Map<String, Object> filterParams) {
        return new FluentComponentQueryImpl(this, filter, filterParams);
    }

    @Override
    public Collection<String> namespaces() {
        return this.componentStore.browseNamespaces(this.facet.contentRepositoryId());
    }

    @Override
    public Collection<String> names(String namespace) {
        return this.componentStore.browseNames(this.facet.contentRepositoryId(), namespace);
    }

    @Override
    public Collection<String> versions(String namespace, String name) {
        return this.componentStore.browseVersions(this.facet.contentRepositoryId(), namespace, name);
    }

    @Override
    public Optional<FluentComponent> find(EntityId externalId) {
        return this.componentStore.readComponent(InternalIds.toInternalId(externalId)).filter(this::containedInRepository).map(component -> new FluentComponentImpl(this.facet, (Component)component));
    }

    private boolean containedInRepository(Component component) {
        int expectedContentRepositoryId = InternalIds.contentRepositoryId(component);
        if (expectedContentRepositoryId == this.facet.contentRepositoryId()) {
            return true;
        }
        if (this.facet.repository().getType() instanceof GroupType) {
            return ((GroupFacet)this.facet.repository().facet(GroupFacet.class)).allMembers().stream().map(InternalIds::contentRepositoryId).filter(Optional::isPresent).map(Optional::get).anyMatch(id -> id == expectedContentRepositoryId);
        }
        return false;
    }
}

