/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentBlobs;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.AttachableBlob;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;
import org.sonatype.nexus.security.ClientInfo;

public class FluentBlobsImpl
extends ComponentSupport
implements FluentBlobs {
    private static final String SYSTEM = "system";
    private final ContentFacetSupport facet;
    private final BlobStore blobStore;

    public FluentBlobsImpl(ContentFacetSupport facet, BlobStore blobStore) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
    }

    @Override
    public BlobStoreMetrics getMetrics() {
        return this.blobStore.getMetrics();
    }

    @Override
    public TempBlob ingest(InputStream in, @Nullable String contentType, Iterable<HashAlgorithm> hashing) {
        return this.ingest(in, contentType, (Map<String, String>)ImmutableMap.of(), hashing);
    }

    @Override
    public TempBlob ingest(InputStream in, @Nullable String contentType, Map<String, String> headers, Iterable<HashAlgorithm> hashing) {
        MultiHashingInputStream hashingStream = new MultiHashingInputStream(hashing, in);
        Blob blob = this.blobStore.create((InputStream)hashingStream, this.tempHeaders(headers, contentType));
        return new TempBlob(blob, hashingStream.hashes(), true, this.blobStore);
    }

    @Override
    public TempBlob ingest(Path path, @Nullable String contentType, Iterable<HashAlgorithm> algorithms, boolean requireHardLink) {
        try {
            Blob blob;
            Map<HashAlgorithm, HashCode> hashes = this.computeHashes(path, algorithms);
            Map<String, String> tempHeaders = this.tempHeaders(Collections.emptyMap(), contentType);
            try {
                blob = this.blobStore.create(path, tempHeaders, Files.size(path), hashes.get(HashAlgorithm.SHA1));
            }
            catch (Exception e) {
                if (requireHardLink) {
                    throw e;
                }
                this.log.debug("Failed to hard-link {}", (Object)path);
                Throwable throwable = null;
                Object var10_12 = null;
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    blob = this.blobStore.create((InputStream)in, tempHeaders);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return new TempBlob(blob, hashes, true, this.blobStore);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Loose catch block
     */
    private Map<HashAlgorithm, HashCode> computeHashes(Path path, Iterable<HashAlgorithm> hashing) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Map map;
                MultiHashingInputStream hashingStream;
                BufferedInputStream in;
                block18: {
                    block17: {
                        in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                        hashingStream = new MultiHashingInputStream(hashing, (InputStream)in);
                        IOUtils.consume((InputStream)hashingStream);
                        map = hashingStream.hashes();
                        if (hashingStream == null) break block17;
                        hashingStream.close();
                    }
                    if (in == null) break block18;
                    ((InputStream)in).close();
                }
                return map;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (hashingStream != null) {
                                hashingStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, String> tempHeaders(Map<String, String> headers, String contentType) {
        Optional<ClientInfo> clientInfo = this.facet.clientInfo();
        ImmutableMap.Builder tempHeaders = ImmutableMap.builder();
        tempHeaders.putAll(headers);
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "BlobStore.temporary-blob", "");
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "Bucket.repo-name", this.facet.repository().getName());
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "BlobStore.blob-name", "temp");
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "BlobStore.created-by", clientInfo.map(ClientInfo::getUserid).orElse(SYSTEM));
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "BlobStore.created-by-ip", clientInfo.map(ClientInfo::getRemoteIP).orElse(SYSTEM));
        this.maybePut((ImmutableMap.Builder<String, String>)tempHeaders, headers, "BlobStore.content-type", Optional.ofNullable(contentType).orElse("application/octet-stream"));
        return tempHeaders.build();
    }

    @Override
    public TempBlob ingest(Payload payload, Iterable<HashAlgorithm> hashing) {
        if (payload instanceof Content) {
            return this.ingest(((Content)payload).getPayload(), hashing);
        }
        if (payload instanceof TempBlobPayload) {
            return ((TempBlobPayload)payload).getTempBlob();
        }
        if (payload instanceof DetachedBlobPayload) {
            DetachedBlobPayload detachedBlobPayload = (DetachedBlobPayload)payload;
            Map<HashAlgorithm, HashCode> hashes = FluentBlobsImpl.hashes(payload, hashing);
            return new AttachableBlob(detachedBlobPayload.getBlob(), hashes, true, this.blobStore);
        }
        try {
            Throwable detachedBlobPayload = null;
            Object var4_8 = null;
            try (InputStream in = payload.openInputStream();){
                return this.ingest(in, this.cleanupContentType(payload.getContentType()), hashing);
            }
            catch (Throwable throwable) {
                if (detachedBlobPayload == null) {
                    detachedBlobPayload = throwable;
                } else if (detachedBlobPayload != throwable) {
                    detachedBlobPayload.addSuppressed(throwable);
                }
                throw detachedBlobPayload;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String cleanupContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semicolonIndex = contentType.indexOf(59);
        if (semicolonIndex == -1) {
            return contentType;
        }
        return contentType.substring(0, semicolonIndex);
    }

    @Override
    public Blob ingest(Path sourceFile, Map<String, String> headers, HashCode sha1, long size) {
        Optional<ClientInfo> clientInfo = this.facet.clientInfo();
        ImmutableMap.Builder newHeaders = ImmutableMap.builder();
        newHeaders.putAll(headers);
        this.maybePut((ImmutableMap.Builder<String, String>)newHeaders, headers, "Bucket.repo-name", this.facet.repository().getName());
        this.maybePut((ImmutableMap.Builder<String, String>)newHeaders, headers, "BlobStore.created-by", clientInfo.map(ClientInfo::getUserid).orElse(SYSTEM));
        this.maybePut((ImmutableMap.Builder<String, String>)newHeaders, headers, "BlobStore.created-by-ip", clientInfo.map(ClientInfo::getRemoteIP).orElse(SYSTEM));
        return this.blobStore.create(sourceFile, (Map)newHeaders.build(), size, sha1);
    }

    @Override
    public Optional<Blob> blob(BlobRef blobRef) {
        return Optional.ofNullable(this.blobStore.get(blobRef.getBlobId()));
    }

    private void maybePut(ImmutableMap.Builder<String, String> builder, Map<String, String> existing, String key, String value) {
        if (!existing.containsKey(key)) {
            builder.put((Object)key, (Object)value);
        }
    }

    private static Map<HashAlgorithm, HashCode> hashes(Payload payload, Iterable<HashAlgorithm> hashing) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = payload.openInputStream();){
                return Hashes.hash(hashing, (InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

